/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.Message;
import com.mpush.api.connection.Connection;
import com.mpush.api.connection.SessionContext;
import com.mpush.api.protocol.Packet;
import com.mpush.client.ClientConfig;
import com.mpush.util.IOUtils;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseMessage
implements Message {
    private static final AtomicInteger SID_SEQ = new AtomicInteger();
    protected final Packet packet;
    protected final Connection connection;

    public BaseMessage(Packet packet, Connection connection) {
        this.packet = packet;
        this.connection = connection;
        this.decodeBody();
    }

    protected void decodeBody() {
        if (this.packet.body != null && this.packet.body.length > 0) {
            byte[] tmp = this.packet.body;
            if (this.packet.hasFlag((byte)1) && this.connection.getSessionContext().cipher != null) {
                tmp = this.connection.getSessionContext().cipher.decrypt(tmp);
            }
            if (this.packet.hasFlag((byte)2)) {
                tmp = IOUtils.uncompress(tmp);
            }
            if (tmp.length == 0) {
                throw new RuntimeException("message decode ex");
            }
            this.packet.body = tmp;
            this.decode(this.packet.body);
        }
    }

    protected void encodeBody() {
        byte[] tmp = this.encode();
        if (tmp != null && tmp.length > 0) {
            byte[] result;
            byte[] result2;
            if (tmp.length > ClientConfig.I.getCompressLimit() && (result2 = IOUtils.compress(tmp)).length > 0) {
                tmp = result2;
                this.packet.addFlag((byte)2);
            }
            SessionContext context = this.connection.getSessionContext();
            if (context.cipher != null && (result = context.cipher.encrypt(tmp)).length > 0) {
                tmp = result;
                this.packet.addFlag((byte)1);
            }
            this.packet.body = tmp;
        }
    }

    protected abstract void decode(byte[] var1);

    protected abstract byte[] encode();

    public Packet createResponse() {
        return new Packet(this.packet.cmd, this.packet.sessionId);
    }

    @Override
    public Packet getPacket() {
        return this.packet;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void send() {
        this.encodeBody();
        this.connection.send(this.packet);
    }

    @Override
    public void sendRaw() {
        this.packet.body = this.encode();
        this.connection.send(this.packet);
    }

    protected static int genSessionId() {
        return SID_SEQ.incrementAndGet();
    }

    public int getSessionId() {
        return this.packet.sessionId;
    }

    public String toString() {
        return "BaseMessage{packet=" + this.packet + ", connection=" + this.connection + '}';
    }
}

