/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.api.Constants;
import com.mpush.api.Logger;
import com.mpush.client.ClientConfig;
import com.mpush.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class AllotClient {
    private List<String> serverAddress = new ArrayList<String>();

    AllotClient() {
    }

    public List<String> getServerAddress() {
        if (this.serverAddress.isEmpty()) {
            this.serverAddress = this.queryServerAddressList();
        }
        return this.serverAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> queryServerAddressList() {
        HttpURLConnection connection;
        ClientConfig config = ClientConfig.I;
        Logger logger = config.getLogger();
        if (config.getAllotServer() == null) {
            if (config.getServerHost() != null) {
                this.serverAddress.add(config.getServerHost() + ":" + config.getServerPort());
            }
            return this.serverAddress;
        }
        try {
            URL url = new URL(config.getAllotServer());
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(false);
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                logger.w("get server address failure statusCode=%d", statusCode);
                connection.disconnect();
                return this.serverAddress;
            }
        }
        catch (IOException e) {
            logger.e(e, "get server address ex, when connect server.", new Object[0]);
            return Collections.emptyList();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        byte[] buffer = new byte[128];
        InputStream in = null;
        try {
            int count;
            in = connection.getInputStream();
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
        }
        catch (IOException ioe) {
            logger.e(ioe, "get server address ex, when read result.", new Object[0]);
            List<String> list = this.serverAddress;
            return list;
        }
        finally {
            IOUtils.close(in);
            connection.disconnect();
        }
        byte[] content = out.toByteArray();
        if (content.length > 0) {
            String result = new String(content, Constants.UTF_8);
            logger.w("get server address success result=%s", result);
            ArrayList<String> serverAddress = new ArrayList<String>();
            for (String s : result.split(",")) {
                serverAddress.add(s);
            }
            this.serverAddress = serverAddress;
        } else {
            logger.w("get server address failure return content empty.", new Object[0]);
        }
        return this.serverAddress;
    }
}

