/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.codec;

import com.mpush.api.Logger;
import com.mpush.api.PacketReader;
import com.mpush.api.PacketReceiver;
import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Packet;
import com.mpush.client.ClientConfig;
import com.mpush.codec.PacketDecoder;
import com.mpush.util.ByteBuf;
import com.mpush.util.thread.NamedThreadFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public final class AsyncPacketReader
implements PacketReader,
Runnable {
    private final NamedThreadFactory threadFactory = new NamedThreadFactory("mp-client-read-t");
    private final Connection connection;
    private final PacketReceiver receiver;
    private final ByteBuf buffer;
    private final Logger logger;
    private Thread thread;

    public AsyncPacketReader(Connection connection, PacketReceiver receiver) {
        this.connection = connection;
        this.receiver = receiver;
        this.buffer = ByteBuf.allocateDirect(Short.MAX_VALUE);
        this.logger = ClientConfig.I.getLogger();
    }

    @Override
    public synchronized void startRead() {
        this.thread = this.threadFactory.newThread(this);
        this.thread.start();
    }

    @Override
    public synchronized void stopRead() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public void run() {
        try {
            this.buffer.clear();
            while (this.connection.isConnected()) {
                ByteBuffer in = this.buffer.checkCapacity(1024).nioBuffer();
                if (!this.read(this.connection.getChannel(), in)) {
                    break;
                }
                in.flip();
                this.decodePacket(in);
                in.compact();
            }
        }
        finally {
            this.logger.w("read an error, do reconnect!!!", new Object[0]);
            this.connection.reconnect();
        }
    }

    private void decodePacket(ByteBuffer in) {
        Packet packet;
        while ((packet = PacketDecoder.decode(in)) != null) {
            this.receiver.onReceive(packet, this.connection);
        }
    }

    private boolean read(SocketChannel channel, ByteBuffer in) {
        int readCount;
        try {
            readCount = channel.read(in);
            this.connection.setLastReadTime();
        }
        catch (IOException e) {
            this.logger.e(e, "read packet ex, do reconnect", new Object[0]);
            readCount = -1;
            this.sleep4Reconnect();
        }
        return readCount > 0;
    }

    private void sleep4Reconnect() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

