/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.security;

import com.mpush.api.connection.Cipher;
import com.mpush.security.CipherBox;
import com.mpush.util.crypto.AESUtils;

public final class AesCipher
implements Cipher {
    public final byte[] key;
    public final byte[] iv;

    public AesCipher(byte[] key, byte[] iv) {
        this.key = key;
        this.iv = iv;
    }

    @Override
    public byte[] decrypt(byte[] data) {
        return AESUtils.decrypt(data, this.key, this.iv);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return AESUtils.encrypt(data, this.key, this.iv);
    }

    public String toString() {
        return this.toString(this.key) + ',' + this.toString(this.iv);
    }

    public String toString(byte[] a) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            if (i != 0) {
                b.append('|');
            }
            b.append(a[i]);
        }
        return b.toString();
    }

    public static byte[] toArray(String str) {
        String[] a = str.split("\\|");
        if (a.length != CipherBox.INSTANCE.getAesKeyLength()) {
            return null;
        }
        byte[] bytes = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            bytes[i] = Byte.parseByte(a[i]);
        }
        return bytes;
    }
}

