/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.explorers;

import com.mwt.explorers.Explorer;
import com.mwt.explorers.GenericExplorer;
import com.mwt.explorers.utilities.ExplorerInformation;
import com.mwt.explorers.utilities.FixedScorer;
import com.mwt.explorers.utilities.FixedVariableActionContext;
import junit.framework.Assert;
import org.junit.Test;

public class GenericExplorerTest {
    private final ExplorerInformation<String> exInfo = new ExplorerInformation(8);
    private final ExplorerInformation<FixedVariableActionContext> varExInfo = new ExplorerInformation(8);

    @Test
    public void fixedAllEqualScorer() {
        this.allEqualScorer("context", this.exInfo);
    }

    @Test
    public void fixedIntegerProgressionScorer() {
        this.integerProgressionScorer("context", this.exInfo);
    }

    @Test
    public void variableAllEqualScorer() {
        this.allEqualScorer(new FixedVariableActionContext(3), this.varExInfo);
    }

    @Test
    public void variableIntegerProgressionScorer() {
        this.integerProgressionScorer(new FixedVariableActionContext(3), this.varExInfo);
    }

    private <T> void allEqualScorer(T context, ExplorerInformation<T> exInfo) {
        FixedScorer scorer = new FixedScorer(1.0f, 1.0f);
        GenericExplorer explorer = new GenericExplorer(scorer, 2);
        int action = exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        Assert.assertEquals((int)2, (int)action);
        Assert.assertEquals((String)("2 abc 0.50000 | " + context), (String)exInfo.recorder.getRecording().trim());
    }

    private <T> void integerProgressionScorer(T context, ExplorerInformation<T> exInfo) {
        FixedScorer scorer = new FixedScorer(1.0f, 2.0f, 3.0f);
        GenericExplorer explorer = new GenericExplorer(scorer, 3);
        int action = exInfo.mwt.chooseAction((Explorer)explorer, "abc", context);
        Assert.assertEquals((int)3, (int)action);
        Assert.assertEquals((String)("3 abc 0.50000 | " + context), (String)exInfo.recorder.getRecording().trim());
    }
}

