/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

public final class Wrapper {
    private final Kind kind;
    private final Element element;

    public static List<Wrapper> allOf(Types util, TypeElement service, TypeElement provider) {
        return Stream.of(Kind.values()).flatMap(kind -> kind.parse(util, service, provider).map(element -> new Wrapper((Kind)((Object)kind), (Element)element))).collect(Collectors.toList());
    }

    private static boolean isOneArgPublicMethod(Types util, ExecutableElement method, TypeElement service) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC) && method.getParameters().size() == 1 && util.isSameType(method.getParameters().get(0).asType(), service.asType());
    }

    public Wrapper(Kind kind, Element element) {
        this.kind = kind;
        this.element = element;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Element getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Wrapper)) {
            return false;
        }
        Wrapper other = (Wrapper)o;
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        return !(this$element == null ? other$element != null : !((Object)this$element).equals(other$element));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : ((Object)$element).hashCode());
        return result;
    }

    public String toString() {
        return "Wrapper(kind=" + (Object)((Object)this.getKind()) + ", element=" + this.getElement() + ")";
    }

    public static enum Kind {
        CONSTRUCTOR{

            @Override
            public Stream<Element> parse(Types util, TypeElement service, TypeElement provider) {
                return ElementFilter.constructorsIn(provider.getEnclosedElements()).stream().filter(method -> Wrapper.isOneArgPublicMethod(util, method, service)).map(Element.class::cast);
            }
        }
        ,
        STATIC_METHOD{

            @Override
            public Stream<Element> parse(Types util, TypeElement service, TypeElement provider) {
                return ElementFilter.methodsIn(provider.getEnclosedElements()).stream().filter(method -> Wrapper.isOneArgPublicMethod(util, method, service)).filter(method -> method.getModifiers().contains((Object)Modifier.STATIC)).filter(method -> util.isSubtype(method.getReturnType(), service.asType())).map(Element.class::cast);
            }
        };


        public abstract Stream<Element> parse(Types var1, TypeElement var2, TypeElement var3);
    }
}

