/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import internal.nbbrd.service.ModuleInfoEntries;
import internal.nbbrd.service.provider.ProviderEntry;
import internal.nbbrd.service.provider.ProviderRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import lombok.NonNull;

final class ModulePathRegistry
implements ProviderRegistry {
    @NonNull
    private final ProcessingEnvironment env;

    public Optional<List<ProviderEntry>> readAll() throws IOException {
        return ModuleInfoEntries.parse(this.env.getFiler()).map(ModulePathRegistry::parseAll);
    }

    static List<ProviderEntry> parseAll(ModuleInfoEntries content) {
        return content.getProvisions().entrySet().stream().flatMap(ModulePathRegistry::parse).collect(Collectors.toList());
    }

    private static Stream<ProviderEntry> parse(Map.Entry<String, List<String>> entry) {
        return entry.getValue().stream().map(provider -> new ProviderEntry((String)entry.getKey(), (String)provider));
    }

    public ModulePathRegistry(@NonNull ProcessingEnvironment env) {
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        this.env = env;
    }
}

