/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.Unreachable;
import nbbrd.service.Mutability;

enum Lifecycle {
    IMMUTABLE,
    MUTABLE,
    CONCURRENT,
    CONSTANT,
    ATOMIC,
    UNSAFE_MUTABLE;


    static Lifecycle of(Mutability mutability, boolean singleton) {
        switch (mutability) {
            case NONE: {
                return singleton ? CONSTANT : IMMUTABLE;
            }
            case BASIC: {
                return singleton ? UNSAFE_MUTABLE : MUTABLE;
            }
            case CONCURRENT: {
                return singleton ? ATOMIC : CONCURRENT;
            }
        }
        throw new Unreachable();
    }

    boolean isSingleton() {
        switch (this) {
            case CONSTANT: 
            case UNSAFE_MUTABLE: 
            case ATOMIC: {
                return true;
            }
        }
        return false;
    }

    boolean isAtomicReference() {
        switch (this) {
            case ATOMIC: 
            case CONCURRENT: {
                return true;
            }
        }
        return false;
    }

    boolean isModifiable() {
        switch (this) {
            case UNSAFE_MUTABLE: 
            case ATOMIC: 
            case CONCURRENT: 
            case MUTABLE: {
                return true;
            }
        }
        return false;
    }

    boolean isThreadSafe() {
        switch (this) {
            case CONSTANT: 
            case ATOMIC: 
            case CONCURRENT: 
            case IMMUTABLE: {
                return true;
            }
        }
        return false;
    }

    Mutability toMutability() {
        switch (this) {
            case CONSTANT: 
            case IMMUTABLE: {
                return Mutability.NONE;
            }
            case UNSAFE_MUTABLE: 
            case MUTABLE: {
                return Mutability.BASIC;
            }
            case ATOMIC: 
            case CONCURRENT: {
                return Mutability.CONCURRENT;
            }
        }
        throw new Unreachable();
    }
}

