/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.ExtEnvironment;
import internal.nbbrd.service.com.squareup.javapoet.ClassName;
import internal.nbbrd.service.definition.Lifecycle;
import internal.nbbrd.service.definition.TypeInstantiator;
import internal.nbbrd.service.definition.TypeWrapper;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import lombok.Generated;
import nbbrd.service.Quantifier;

final class LoadDefinition {
    private final Quantifier quantifier;
    private final Lifecycle lifecycle;
    private final ClassName serviceType;
    private final Optional<TypeInstantiator> fallback;
    private final Optional<TypeWrapper> wrapper;
    private final Optional<TypeInstantiator> preprocessor;
    private final String loaderName;
    private final Optional<TypeInstantiator> backend;
    private final Optional<TypeInstantiator> cleaner;

    public ClassName resolveLoaderName() {
        return LoadDefinition.resolveLoaderName(this.loaderName, this.serviceType);
    }

    static ClassName resolveLoaderName(String loaderName, ClassName serviceType) {
        if (!loaderName.isEmpty()) {
            return ClassName.bestGuess(loaderName);
        }
        ClassName top = serviceType.topLevelClassName();
        ClassName topLoader = ClassName.get(top.packageName(), top.simpleName() + "Loader", new String[0]);
        if (top.equals(serviceType)) {
            return topLoader;
        }
        return topLoader.nestedClass(serviceType.simpleName());
    }

    static TypeMirror getPreprocessorType(ExtEnvironment env, TypeMirror service) {
        Types types = env.getTypeUtils();
        DeclaredType streamOf = types.getDeclaredType(env.asTypeElement(Stream.class), service);
        return types.getDeclaredType(env.asTypeElement(UnaryOperator.class), streamOf);
    }

    static TypeMirror getBackendType(ExtEnvironment env, TypeMirror service) {
        Types types = env.getTypeUtils();
        DeclaredType classOf = types.getDeclaredType(env.asTypeElement(Class.class), new TypeMirror[0]);
        DeclaredType iterableOf = types.getDeclaredType(env.asTypeElement(Iterable.class), new TypeMirror[0]);
        WildcardType extendsIterableOf = types.getWildcardType(iterableOf, null);
        return types.getDeclaredType(env.asTypeElement(Function.class), classOf, extendsIterableOf);
    }

    static TypeMirror getCleanerType(ExtEnvironment env, TypeMirror service) {
        Types types = env.getTypeUtils();
        DeclaredType iterableOf = types.getDeclaredType(env.asTypeElement(Iterable.class), new TypeMirror[0]);
        WildcardType extendsIterableOf = types.getWildcardType(iterableOf, null);
        return types.getDeclaredType(env.asTypeElement(Consumer.class), extendsIterableOf);
    }

    @Generated
    LoadDefinition(Quantifier quantifier, Lifecycle lifecycle, ClassName serviceType, Optional<TypeInstantiator> fallback, Optional<TypeWrapper> wrapper, Optional<TypeInstantiator> preprocessor, String loaderName, Optional<TypeInstantiator> backend, Optional<TypeInstantiator> cleaner) {
        this.quantifier = quantifier;
        this.lifecycle = lifecycle;
        this.serviceType = serviceType;
        this.fallback = fallback;
        this.wrapper = wrapper;
        this.preprocessor = preprocessor;
        this.loaderName = loaderName;
        this.backend = backend;
        this.cleaner = cleaner;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    @Generated
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Generated
    public ClassName getServiceType() {
        return this.serviceType;
    }

    @Generated
    public Optional<TypeInstantiator> getFallback() {
        return this.fallback;
    }

    @Generated
    public Optional<TypeWrapper> getWrapper() {
        return this.wrapper;
    }

    @Generated
    public Optional<TypeInstantiator> getPreprocessor() {
        return this.preprocessor;
    }

    @Generated
    public String getLoaderName() {
        return this.loaderName;
    }

    @Generated
    public Optional<TypeInstantiator> getBackend() {
        return this.backend;
    }

    @Generated
    public Optional<TypeInstantiator> getCleaner() {
        return this.cleaner;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadDefinition)) {
            return false;
        }
        LoadDefinition other = (LoadDefinition)o;
        Quantifier this$quantifier = this.getQuantifier();
        Quantifier other$quantifier = other.getQuantifier();
        if (this$quantifier == null ? other$quantifier != null : !this$quantifier.equals(other$quantifier)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)((Object)this$lifecycle)).equals((Object)other$lifecycle)) {
            return false;
        }
        ClassName this$serviceType = this.getServiceType();
        ClassName other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !((Object)this$serviceType).equals(other$serviceType)) {
            return false;
        }
        Optional<TypeInstantiator> this$fallback = this.getFallback();
        Optional<TypeInstantiator> other$fallback = other.getFallback();
        if (this$fallback == null ? other$fallback != null : !((Object)this$fallback).equals(other$fallback)) {
            return false;
        }
        Optional<TypeWrapper> this$wrapper = this.getWrapper();
        Optional<TypeWrapper> other$wrapper = other.getWrapper();
        if (this$wrapper == null ? other$wrapper != null : !((Object)this$wrapper).equals(other$wrapper)) {
            return false;
        }
        Optional<TypeInstantiator> this$preprocessor = this.getPreprocessor();
        Optional<TypeInstantiator> other$preprocessor = other.getPreprocessor();
        if (this$preprocessor == null ? other$preprocessor != null : !((Object)this$preprocessor).equals(other$preprocessor)) {
            return false;
        }
        String this$loaderName = this.getLoaderName();
        String other$loaderName = other.getLoaderName();
        if (this$loaderName == null ? other$loaderName != null : !this$loaderName.equals(other$loaderName)) {
            return false;
        }
        Optional<TypeInstantiator> this$backend = this.getBackend();
        Optional<TypeInstantiator> other$backend = other.getBackend();
        if (this$backend == null ? other$backend != null : !((Object)this$backend).equals(other$backend)) {
            return false;
        }
        Optional<TypeInstantiator> this$cleaner = this.getCleaner();
        Optional<TypeInstantiator> other$cleaner = other.getCleaner();
        return !(this$cleaner == null ? other$cleaner != null : !((Object)this$cleaner).equals(other$cleaner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Quantifier $quantifier = this.getQuantifier();
        result = result * 59 + ($quantifier == null ? 43 : $quantifier.hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)((Object)$lifecycle)).hashCode());
        ClassName $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : ((Object)$serviceType).hashCode());
        Optional<TypeInstantiator> $fallback = this.getFallback();
        result = result * 59 + ($fallback == null ? 43 : ((Object)$fallback).hashCode());
        Optional<TypeWrapper> $wrapper = this.getWrapper();
        result = result * 59 + ($wrapper == null ? 43 : ((Object)$wrapper).hashCode());
        Optional<TypeInstantiator> $preprocessor = this.getPreprocessor();
        result = result * 59 + ($preprocessor == null ? 43 : ((Object)$preprocessor).hashCode());
        String $loaderName = this.getLoaderName();
        result = result * 59 + ($loaderName == null ? 43 : $loaderName.hashCode());
        Optional<TypeInstantiator> $backend = this.getBackend();
        result = result * 59 + ($backend == null ? 43 : ((Object)$backend).hashCode());
        Optional<TypeInstantiator> $cleaner = this.getCleaner();
        result = result * 59 + ($cleaner == null ? 43 : ((Object)$cleaner).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LoadDefinition(quantifier=" + this.getQuantifier() + ", lifecycle=" + (Object)((Object)this.getLifecycle()) + ", serviceType=" + this.getServiceType() + ", fallback=" + this.getFallback() + ", wrapper=" + this.getWrapper() + ", preprocessor=" + this.getPreprocessor() + ", loaderName=" + this.getLoaderName() + ", backend=" + this.getBackend() + ", cleaner=" + this.getCleaner() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private Quantifier quantifier;
        @Generated
        private Lifecycle lifecycle;
        @Generated
        private ClassName serviceType;
        @Generated
        private Optional<TypeInstantiator> fallback;
        @Generated
        private Optional<TypeWrapper> wrapper;
        @Generated
        private Optional<TypeInstantiator> preprocessor;
        @Generated
        private String loaderName;
        @Generated
        private Optional<TypeInstantiator> backend;
        @Generated
        private Optional<TypeInstantiator> cleaner;

        @Generated
        Builder() {
        }

        @Generated
        public Builder quantifier(Quantifier quantifier) {
            this.quantifier = quantifier;
            return this;
        }

        @Generated
        public Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Generated
        public Builder serviceType(ClassName serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Generated
        public Builder fallback(Optional<TypeInstantiator> fallback) {
            this.fallback = fallback;
            return this;
        }

        @Generated
        public Builder wrapper(Optional<TypeWrapper> wrapper) {
            this.wrapper = wrapper;
            return this;
        }

        @Generated
        public Builder preprocessor(Optional<TypeInstantiator> preprocessor) {
            this.preprocessor = preprocessor;
            return this;
        }

        @Generated
        public Builder loaderName(String loaderName) {
            this.loaderName = loaderName;
            return this;
        }

        @Generated
        public Builder backend(Optional<TypeInstantiator> backend) {
            this.backend = backend;
            return this;
        }

        @Generated
        public Builder cleaner(Optional<TypeInstantiator> cleaner) {
            this.cleaner = cleaner;
            return this;
        }

        @Generated
        public LoadDefinition build() {
            return new LoadDefinition(this.quantifier, this.lifecycle, this.serviceType, this.fallback, this.wrapper, this.preprocessor, this.loaderName, this.backend, this.cleaner);
        }

        @Generated
        public String toString() {
            return "LoadDefinition.Builder(quantifier=" + this.quantifier + ", lifecycle=" + (Object)((Object)this.lifecycle) + ", serviceType=" + this.serviceType + ", fallback=" + this.fallback + ", wrapper=" + this.wrapper + ", preprocessor=" + this.preprocessor + ", loaderName=" + this.loaderName + ", backend=" + this.backend + ", cleaner=" + this.cleaner + ")";
        }
    }
}

