/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.ProcessorUtil;
import internal.nbbrd.service.Unreachable;
import internal.nbbrd.service.com.squareup.javapoet.ClassName;
import internal.nbbrd.service.com.squareup.javapoet.JavaFile;
import internal.nbbrd.service.com.squareup.javapoet.TypeSpec;
import internal.nbbrd.service.definition.LoadData;
import internal.nbbrd.service.definition.LoadDefinition;
import internal.nbbrd.service.definition.LoadFilter;
import internal.nbbrd.service.definition.LoadSorter;
import internal.nbbrd.service.definition.ServiceDefinitionChecker;
import internal.nbbrd.service.definition.ServiceDefinitionCollector;
import internal.nbbrd.service.definition.ServiceDefinitionGenerator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"nbbrd.service.ServiceDefinition", "nbbrd.service.ServiceFilter", "nbbrd.service.ServiceSorter"})
public final class ServiceDefinitionProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ServiceDefinitionCollector collector = new ServiceDefinitionCollector(this.processingEnv);
        ServiceDefinitionChecker checker = new ServiceDefinitionChecker(this.processingEnv);
        LoadData data = collector.collect(annotations, roundEnv);
        if (!data.getDefinitions().isEmpty()) {
            checker.checkModuleInfo(data.getDefinitions());
        }
        Map<ClassName, List<LoadDefinition>> definitionsByTopLevel = data.getDefinitions().stream().filter(checker::checkDefinition).collect(Collectors.groupingBy(definition -> definition.resolveLoaderName().topLevelClassName()));
        Map<ClassName, List<LoadFilter>> filtersByService = data.getFilters().stream().filter(checker::checkFilter).collect(Collectors.groupingBy(filter -> filter.getServiceType().map(ClassName::get).orElseThrow(Unreachable::new)));
        Map<ClassName, List<LoadSorter>> sortersByService = data.getSorters().stream().filter(checker::checkSorter).collect(Collectors.groupingBy(sorter -> sorter.getServiceType().map(ClassName::get).orElseThrow(Unreachable::new)));
        definitionsByTopLevel.forEach((topLevel, definitions) -> this.generate((ClassName)topLevel, ServiceDefinitionGenerator.allOf(definitions, filtersByService, sortersByService)));
        return true;
    }

    private void generate(ClassName topLevel, List<ServiceDefinitionGenerator> generators) {
        TypeSpec typeSpec = this.isNotNested(topLevel, generators) ? generators.get(0).generate(false) : this.generateNested(topLevel, generators);
        ProcessorUtil.write(this.processingEnv, JavaFile.builder(topLevel.packageName(), typeSpec).build());
    }

    private boolean isNotNested(ClassName topLevel, List<ServiceDefinitionGenerator> generators) {
        return generators.size() == 1 && topLevel.equals(generators.get(0).getDefinition().resolveLoaderName());
    }

    private TypeSpec generateNested(ClassName topLevel, List<ServiceDefinitionGenerator> generators) {
        return TypeSpec.classBuilder(topLevel).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypes(generators.stream().map(o -> o.generate(true)).collect(Collectors.toList())).build();
    }
}

