/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service;

import internal.nbbrd.service.Java9BaseListener;
import internal.nbbrd.service.Java9Lexer;
import internal.nbbrd.service.Java9Parser;
import internal.nbbrd.service.org.antlr.v4.runtime.CharStream;
import internal.nbbrd.service.org.antlr.v4.runtime.CharStreams;
import internal.nbbrd.service.org.antlr.v4.runtime.CommonTokenStream;
import internal.nbbrd.service.org.antlr.v4.runtime.tree.ParseTree;
import internal.nbbrd.service.org.antlr.v4.runtime.tree.ParseTreeWalker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.Generated;

public final class ModuleInfoEntries {
    private final List<String> usages;
    private final Map<String, List<String>> provisions;

    public static Optional<ModuleInfoEntries> parse(Filer filer) throws IOException {
        try {
            FileObject src = filer.getResource(StandardLocation.SOURCE_PATH, "", "module-info.java");
            return Optional.of(ModuleInfoEntries.parse(src.getCharContent(false)));
        }
        catch (FileNotFoundException | RuntimeException | NoSuchFileException | FilerException ex) {
            return Optional.empty();
        }
    }

    static ModuleInfoEntries parse(CharSequence content) {
        return ModuleInfoEntries.parse(CharStreams.fromString(content.toString()));
    }

    static ModuleInfoEntries parse(CharStream content) {
        Java9Lexer lexer = new Java9Lexer(content);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        Java9Parser parser = new Java9Parser(tokens);
        Java9Parser.CompilationUnitContext tree = parser.compilationUnit();
        ModuleListener listener = new ModuleListener();
        new ParseTreeWalker().walk(listener, tree);
        Builder result = ModuleInfoEntries.builder();
        result.provisions(listener.getProvisions());
        result.usages(listener.getUsages());
        return result.build();
    }

    @Generated
    private static Map<String, List<String>> $default$provisions() {
        return Collections.emptyMap();
    }

    @Generated
    ModuleInfoEntries(List<String> usages, Map<String, List<String>> provisions) {
        this.usages = usages;
        this.provisions = provisions;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public List<String> getUsages() {
        return this.usages;
    }

    @Generated
    public Map<String, List<String>> getProvisions() {
        return this.provisions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleInfoEntries)) {
            return false;
        }
        ModuleInfoEntries other = (ModuleInfoEntries)o;
        List<String> this$usages = this.getUsages();
        List<String> other$usages = other.getUsages();
        if (this$usages == null ? other$usages != null : !((Object)this$usages).equals(other$usages)) {
            return false;
        }
        Map<String, List<String>> this$provisions = this.getProvisions();
        Map<String, List<String>> other$provisions = other.getProvisions();
        return !(this$provisions == null ? other$provisions != null : !((Object)this$provisions).equals(other$provisions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $usages = this.getUsages();
        result = result * 59 + ($usages == null ? 43 : ((Object)$usages).hashCode());
        Map<String, List<String>> $provisions = this.getProvisions();
        result = result * 59 + ($provisions == null ? 43 : ((Object)$provisions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ModuleInfoEntries(usages=" + this.getUsages() + ", provisions=" + this.getProvisions() + ")";
    }

    private static final class ModuleListener
    extends Java9BaseListener {
        private final List<String> importDecls = new ArrayList<String>();
        private final List<String> usesDecls = new ArrayList<String>();
        private final Map<String, List<String>> providesDecls = new HashMap<String, List<String>>();
        private static final int SERVICE_IDX = 1;
        private static final int PROVIDER_IDX = 3;

        private ModuleListener() {
        }

        @Override
        public void enterImportDeclaration(Java9Parser.ImportDeclarationContext ctx) {
            IntStream.range(0, ctx.getChildCount()).mapToObj(index -> ctx.getChild(index).getChild(1).getText()).forEach(this.importDecls::add);
        }

        @Override
        public void enterModuleDirective(Java9Parser.ModuleDirectiveContext ctx) {
            switch (ModuleDirectiveType.parse(ctx)) {
                case PROVIDES: {
                    String service = ctx.getChild(1).getText();
                    List providers = IntStream.range(3, ctx.getChildCount()).mapToObj(ctx::getChild).filter(Java9Parser.TypeNameContext.class::isInstance).map(ParseTree::getText).collect(Collectors.toList());
                    this.providesDecls.put(service, providers);
                    break;
                }
                case USES: {
                    this.usesDecls.add(ctx.getChild(1).getText());
                }
            }
        }

        private String resolveTypeName(String input) {
            String expected = "." + input.split("\\.", -1)[0];
            return this.importDecls.stream().filter(importDecl -> importDecl.endsWith(expected)).map(o -> o.substring(0, o.lastIndexOf(expected)) + "." + input).findFirst().orElse(input);
        }

        List<String> getUsages() {
            return this.usesDecls.stream().map(this::resolveTypeName).collect(Collectors.toList());
        }

        Map<String, List<String>> getProvisions() {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            this.providesDecls.forEach((k, v) -> result.put(this.resolveTypeName((String)k), v.stream().map(this::resolveTypeName).collect(Collectors.toList())));
            return result;
        }
    }

    public static class Builder {
        @Generated
        private ArrayList<String> usages;
        @Generated
        private boolean provisions$set;
        @Generated
        private Map<String, List<String>> provisions$value;

        public Builder provision(String key, String value) {
            if (!this.provisions$set) {
                this.provisions$set = true;
                this.provisions$value = new HashMap<String, List<String>>();
            }
            this.provisions$value.computeIfAbsent(key, o -> new ArrayList()).add(value);
            return this;
        }

        @Generated
        Builder() {
        }

        @Generated
        public Builder usage(String usage) {
            if (this.usages == null) {
                this.usages = new ArrayList();
            }
            this.usages.add(usage);
            return this;
        }

        @Generated
        public Builder usages(Collection<? extends String> usages) {
            if (usages == null) {
                throw new NullPointerException("usages cannot be null");
            }
            if (this.usages == null) {
                this.usages = new ArrayList();
            }
            this.usages.addAll(usages);
            return this;
        }

        @Generated
        public Builder clearUsages() {
            if (this.usages != null) {
                this.usages.clear();
            }
            return this;
        }

        @Generated
        public Builder provisions(Map<String, List<String>> provisions) {
            this.provisions$value = provisions;
            this.provisions$set = true;
            return this;
        }

        @Generated
        public ModuleInfoEntries build() {
            List<String> usages;
            switch (this.usages == null ? 0 : this.usages.size()) {
                case 0: {
                    usages = Collections.emptyList();
                    break;
                }
                case 1: {
                    usages = Collections.singletonList(this.usages.get(0));
                    break;
                }
                default: {
                    usages = Collections.unmodifiableList(new ArrayList<String>(this.usages));
                }
            }
            Map provisions$value = this.provisions$value;
            if (!this.provisions$set) {
                provisions$value = ModuleInfoEntries.$default$provisions();
            }
            return new ModuleInfoEntries(usages, provisions$value);
        }

        @Generated
        public String toString() {
            return "ModuleInfoEntries.Builder(usages=" + this.usages + ", provisions$value=" + this.provisions$value + ")";
        }
    }

    private static enum ModuleDirectiveType {
        UNKNOWN(""),
        PROVIDES("provides"),
        USES("uses");

        private final String keyword;
        private static final int MODULE_DIRECTIVE_KEYWORD_IDX = 0;

        static ModuleDirectiveType parse(Java9Parser.ModuleDirectiveContext ctx) {
            if (ctx.getChildCount() > 0) {
                String keyword = ctx.getChild(0).getText();
                for (ModuleDirectiveType type : ModuleDirectiveType.values()) {
                    if (!type.keyword.equals(keyword)) continue;
                    return type;
                }
            }
            return UNKNOWN;
        }

        @Generated
        private ModuleDirectiveType(String keyword) {
            this.keyword = keyword;
        }
    }
}

