/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.ExtEnvironment;
import internal.nbbrd.service.ModuleInfoEntries;
import internal.nbbrd.service.definition.Lifecycle;
import internal.nbbrd.service.definition.LoadDefinition;
import internal.nbbrd.service.definition.LoadFilter;
import internal.nbbrd.service.definition.LoadSorter;
import internal.nbbrd.service.definition.TypeInstantiator;
import internal.nbbrd.service.definition.TypeWrapper;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import nbbrd.service.Quantifier;
import nbbrd.service.ServiceDefinition;

final class ServiceDefinitionChecker {
    private final ExtEnvironment env;
    private final PrimitiveType booleanType;

    public ServiceDefinitionChecker(ProcessingEnvironment env) {
        this.env = new ExtEnvironment(env);
        this.booleanType = env.getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN);
    }

    public void checkModuleInfo(List<LoadDefinition> definitions) {
        try {
            ModuleInfoEntries.parse(this.env.getFiler()).map(ModuleInfoEntries::getUsages).ifPresent(usages -> this.checkModuleInfoUsages((List<String>)usages, definitions));
        }
        catch (IOException ex) {
            String msg = ex.getClass().getSimpleName() + ": " + ex.getMessage();
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
    }

    private void checkModuleInfoUsages(List<String> usages, List<LoadDefinition> definitions) {
        definitions.stream().map(definition -> definition.getServiceType().toString()).filter(serviceType -> !usages.contains(serviceType)).map(this.env::asTypeElement).forEachOrdered(ref -> this.env.error((Element)ref, "Missing module-info directive 'uses " + ref + "'"));
    }

    public boolean checkFilter(LoadFilter filter) {
        Types types = this.env.getTypeUtils();
        ExecutableElement x = filter.getMethod();
        if (x.getModifiers().contains((Object)Modifier.STATIC)) {
            this.env.error(x, "Filter method does not apply to static methods");
            return false;
        }
        if (!filter.getServiceType().isPresent() || filter.getServiceType().get().getAnnotation(ServiceDefinition.class) == null) {
            this.env.error(x, "Filter method only applies to methods of a service");
            return false;
        }
        if (!x.getParameters().isEmpty()) {
            this.env.error(x, "Filter method must have no-args");
            return false;
        }
        if (!types.isSameType(x.getReturnType(), this.booleanType)) {
            this.env.error(x, "Filter method must return boolean");
            return false;
        }
        return true;
    }

    public boolean checkSorter(LoadSorter sorter) {
        ExecutableElement x = sorter.getMethod();
        if (x.getModifiers().contains((Object)Modifier.STATIC)) {
            this.env.error(x, "Sorter method does not apply to static methods");
            return false;
        }
        if (!sorter.getServiceType().isPresent() || sorter.getServiceType().get().getAnnotation(ServiceDefinition.class) == null) {
            this.env.error(x, "Sorter method only applies to methods of a service");
            return false;
        }
        if (!x.getParameters().isEmpty()) {
            this.env.error(x, "Sorter method must have no-args");
            return false;
        }
        if (!sorter.getKeyType().isPresent()) {
            this.env.error(x, "Sorter method must return double, int, long or comparable");
            return false;
        }
        return true;
    }

    public boolean checkDefinition(LoadDefinition definition) {
        Types types = this.env.getTypeUtils();
        TypeElement service = this.env.asTypeElement(definition.getServiceType());
        if (!this.checkFallback(definition.getQuantifier(), definition.getFallback(), service, types)) {
            return false;
        }
        if (!this.checkWrapper(definition.getWrapper(), service, types)) {
            return false;
        }
        if (!this.checkPreprocessor(definition.getPreprocessor(), service, types)) {
            return false;
        }
        if (!this.checkBackend(definition.getBackend(), service, types)) {
            return false;
        }
        if (!this.checkCleaner(definition.getCleaner(), service, types)) {
            return false;
        }
        return this.checkMutability(definition, service, types);
    }

    private boolean checkFallback(Quantifier quantifier, Optional<TypeInstantiator> fallback, TypeElement service, Types types) {
        switch (quantifier) {
            case SINGLE: {
                if (fallback.isPresent()) break;
                this.env.warn(service, String.format("Missing fallback for service '%1$s'", service));
                break;
            }
            case MULTIPLE: 
            case OPTIONAL: {
                if (!fallback.isPresent()) break;
                this.env.warn(service, String.format("Useless fallback for service '%1$s'", service));
            }
        }
        return !fallback.isPresent() || this.checkFallbackTypeHandler(fallback.get(), service, types);
    }

    private boolean checkFallbackTypeHandler(TypeInstantiator handler, TypeElement service, Types types) {
        if (!types.isAssignable(handler.getType(), types.erasure(service.asType()))) {
            this.env.error(service, String.format("Fallback '%1$s' doesn't extend nor implement service '%2$s'", handler.getType(), service));
            return false;
        }
        return this.checkInstanceFactories(service, handler.getType(), handler);
    }

    private boolean checkWrapper(Optional<TypeWrapper> wrapper, TypeElement service, Types types) {
        return !wrapper.isPresent() || this.checkWrapperTypeHandler(wrapper.get(), service, types);
    }

    private boolean checkWrapperTypeHandler(TypeWrapper handler, TypeElement service, Types types) {
        if (!types.isAssignable(handler.getType(), types.erasure(service.asType()))) {
            this.env.error(service, String.format("Wrapper '%1$s' doesn't extend nor implement service '%2$s'", handler.getType(), service));
            return false;
        }
        return this.checkWrapperFactories(service, handler.getType(), handler);
    }

    private boolean checkPreprocessor(Optional<TypeInstantiator> preprocessor, TypeElement service, Types types) {
        return !preprocessor.isPresent() || this.checkPreprocessorTypeHandler(preprocessor.get(), service, types);
    }

    private boolean checkPreprocessorTypeHandler(TypeInstantiator handler, TypeElement service, Types types) {
        TypeMirror expectedType = LoadDefinition.getPreprocessorType(this.env, service.asType());
        if (!types.isAssignable(handler.getType(), expectedType)) {
            this.env.error(service, String.format("Preprocessor '%1$s' doesn't extend nor implement '%2$s'", handler.getType(), expectedType));
            return false;
        }
        return this.checkInstanceFactories(service, handler.getType(), handler);
    }

    private boolean checkBackend(Optional<TypeInstantiator> backend, TypeElement service, Types types) {
        return !backend.isPresent() || this.checkBackendTypeHandler(backend.get(), service, types);
    }

    private boolean checkBackendTypeHandler(TypeInstantiator handler, TypeElement service, Types types) {
        TypeMirror expectedType = LoadDefinition.getBackendType(this.env, service.asType());
        if (!types.isAssignable(handler.getType(), expectedType)) {
            this.env.error(service, String.format("Backend '%1$s' doesn't extend nor implement '%2$s'", handler.getType(), expectedType));
            return false;
        }
        return this.checkInstanceFactories(service, handler.getType(), handler);
    }

    private boolean checkCleaner(Optional<TypeInstantiator> cleaner, TypeElement service, Types types) {
        return !cleaner.isPresent() || this.checkCleanerTypeHandler(cleaner.get(), service, types);
    }

    private boolean checkCleanerTypeHandler(TypeInstantiator handler, TypeElement service, Types types) {
        TypeMirror expectedType = LoadDefinition.getCleanerType(this.env, service.asType());
        if (!types.isAssignable(handler.getType(), expectedType)) {
            this.env.error(service, String.format("Cleaner '%1$s' doesn't extend nor implement '%2$s'", handler.getType(), expectedType));
            return false;
        }
        return this.checkInstanceFactories(service, handler.getType(), handler);
    }

    private boolean checkMutability(LoadDefinition definition, TypeElement service, Types types) {
        if (definition.getLifecycle() == Lifecycle.UNSAFE_MUTABLE) {
            this.env.warn(service, String.format("Thread-unsafe singleton for '%1$s'", service));
        }
        return true;
    }

    private boolean checkInstanceFactories(TypeElement annotatedElement, TypeMirror type, TypeInstantiator instance) {
        if (!instance.select().isPresent()) {
            this.env.error(annotatedElement, String.format("Don't know how to instantiate '%1$s'", type));
            return false;
        }
        return true;
    }

    private boolean checkWrapperFactories(TypeElement annotatedElement, TypeMirror type, TypeWrapper instance) {
        if (!instance.select().isPresent()) {
            this.env.error(annotatedElement, String.format("Don't know how to wrap '%1$s'", type));
            return false;
        }
        return true;
    }
}

