/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.ExtEnvironment;
import internal.nbbrd.service.Instantiator;
import internal.nbbrd.service.ProcessorUtil;
import internal.nbbrd.service.Wrapper;
import internal.nbbrd.service.com.squareup.javapoet.ClassName;
import internal.nbbrd.service.definition.Lifecycle;
import internal.nbbrd.service.definition.LoadData;
import internal.nbbrd.service.definition.LoadDefinition;
import internal.nbbrd.service.definition.LoadFilter;
import internal.nbbrd.service.definition.LoadSorter;
import internal.nbbrd.service.definition.TypeInstantiator;
import internal.nbbrd.service.definition.TypeWrapper;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import nbbrd.service.ServiceDefinition;
import nbbrd.service.ServiceFilter;
import nbbrd.service.ServiceSorter;

final class ServiceDefinitionCollector {
    private final ExtEnvironment env;
    private final PrimitiveType intType;
    private final PrimitiveType longType;
    private final PrimitiveType doubleType;
    private final DeclaredType comparableType;

    public ServiceDefinitionCollector(ProcessingEnvironment env) {
        this.env = new ExtEnvironment(env);
        Types types = env.getTypeUtils();
        this.intType = types.getPrimitiveType(TypeKind.INT);
        this.longType = types.getPrimitiveType(TypeKind.LONG);
        this.doubleType = types.getPrimitiveType(TypeKind.DOUBLE);
        this.comparableType = types.getDeclaredType(this.env.asTypeElement(Comparable.class), new TypeMirror[0]);
    }

    public LoadData collect(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        LoadData.Builder result = LoadData.builder();
        for (TypeElement typeElement : annotations) {
            switch (typeElement.getSimpleName().toString()) {
                case "ServiceDefinition": {
                    roundEnv.getElementsAnnotatedWith(typeElement).stream().map(TypeElement.class::cast).map(this::definitionOf).forEach(result::definition);
                    break;
                }
                case "ServiceFilter": {
                    roundEnv.getElementsAnnotatedWith(typeElement).stream().map(ExecutableElement.class::cast).map(this::filterOf).forEach(result::filter);
                    break;
                }
                case "ServiceSorter": {
                    roundEnv.getElementsAnnotatedWith(typeElement).stream().map(ExecutableElement.class::cast).map(this::sorterOf).forEach(result::sorter);
                }
            }
        }
        return result.build();
    }

    private LoadDefinition definitionOf(TypeElement serviceType) {
        ServiceDefinition annotation = serviceType.getAnnotation(ServiceDefinition.class);
        Types types = this.env.getTypeUtils();
        Optional<TypeInstantiator> fallback = this.nonNull(() -> ((ServiceDefinition)annotation).fallback(), Void.class).map(fallbackType -> new TypeInstantiator((TypeMirror)fallbackType, Instantiator.allOf(types, serviceType, this.env.asTypeElement((TypeMirror)fallbackType))));
        Optional<TypeWrapper> wrapper = this.nonNull(() -> ((ServiceDefinition)annotation).wrapper(), Void.class).map(wrapperType -> new TypeWrapper((TypeMirror)wrapperType, Wrapper.allOf(types, serviceType, this.env.asTypeElement((TypeMirror)wrapperType))));
        Optional<TypeInstantiator> preprocessor = this.nonNull(() -> ((ServiceDefinition)annotation).preprocessor(), ServiceDefinition.NoProcessing.class).map(preprocessorType -> new TypeInstantiator((TypeMirror)preprocessorType, Instantiator.allOf(types, this.env.asTypeElement((TypeMirror)preprocessorType), this.env.asTypeElement((TypeMirror)preprocessorType))));
        Optional<TypeInstantiator> backend = this.nonNull(() -> ((ServiceDefinition)annotation).backend(), ServiceDefinition.DefaultBackend.class).map(type -> new TypeInstantiator((TypeMirror)type, Instantiator.allOf(types, this.env.asTypeElement((TypeMirror)type), this.env.asTypeElement((TypeMirror)type))));
        Optional<TypeInstantiator> cleaner = this.nonNull(() -> ((ServiceDefinition)annotation).cleaner(), ServiceDefinition.DefaultCleaner.class).map(type -> new TypeInstantiator((TypeMirror)type, Instantiator.allOf(types, this.env.asTypeElement((TypeMirror)type), this.env.asTypeElement((TypeMirror)type))));
        return LoadDefinition.builder().quantifier(annotation.quantifier()).lifecycle(Lifecycle.of(annotation.mutability(), annotation.singleton())).serviceType(ClassName.get(serviceType)).fallback(fallback).wrapper(wrapper).preprocessor(preprocessor).loaderName(annotation.loaderName()).backend(backend).cleaner(cleaner).batch(annotation.batch()).batchName(annotation.batchName()).build();
    }

    private LoadFilter filterOf(ExecutableElement x) {
        ServiceFilter annotation = x.getAnnotation(ServiceFilter.class);
        return new LoadFilter(x, annotation.negate(), annotation.position(), Optional.ofNullable(this.getServiceTypeOrNull(x)));
    }

    private LoadSorter sorterOf(ExecutableElement x) {
        ServiceSorter annotation = x.getAnnotation(ServiceSorter.class);
        return new LoadSorter(x, annotation.reverse(), annotation.position(), Optional.ofNullable(this.getKeyTypeOrNull(x)), Optional.ofNullable(this.getServiceTypeOrNull(x)));
    }

    private LoadSorter.KeyType getKeyTypeOrNull(ExecutableElement x) {
        Types types = this.env.getTypeUtils();
        if (types.isSameType(x.getReturnType(), this.doubleType)) {
            return LoadSorter.KeyType.DOUBLE;
        }
        if (types.isSameType(x.getReturnType(), this.intType)) {
            return LoadSorter.KeyType.INT;
        }
        if (types.isSameType(x.getReturnType(), this.longType)) {
            return LoadSorter.KeyType.LONG;
        }
        if (types.isAssignable(x.getReturnType(), this.comparableType)) {
            return LoadSorter.KeyType.COMPARABLE;
        }
        return null;
    }

    private TypeElement getServiceTypeOrNull(ExecutableElement x) {
        return x.getModifiers().contains((Object)Modifier.STATIC) ? null : (TypeElement)x.getEnclosingElement();
    }

    private Optional<TypeMirror> nonNull(Supplier<Class<?>> type, Class<?> nullType) {
        TypeMirror nullTypeMirror = this.env.asTypeElement(nullType).asType();
        return Optional.of(ProcessorUtil.extractResultType(type)).filter(typeMirror -> !this.env.getTypeUtils().isSameType((TypeMirror)typeMirror, nullTypeMirror));
    }
}

