/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import internal.nbbrd.service.provider.ProviderRef;
import internal.nbbrd.service.provider.ServiceProviderChecker;
import internal.nbbrd.service.provider.ServiceProviderCollector;
import internal.nbbrd.service.provider.ServiceProviderGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"nbbrd.service.ServiceProvider", "nbbrd.service.ServiceProvider.List"})
public final class ServiceProviderProcessor
extends AbstractProcessor {
    private final ServiceProviderCollector collector = new ServiceProviderCollector(() -> this.processingEnv);
    private final ServiceProviderChecker checker = new ServiceProviderChecker(() -> this.processingEnv);
    private final ServiceProviderGenerator generator = new ServiceProviderGenerator(() -> this.processingEnv);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.collector.collect(annotations, roundEnv);
        if (roundEnv.processingOver()) {
            List<ProviderRef> providers = this.collector.build();
            try {
                if (this.checker.check(providers)) {
                    this.generator.generate(providers);
                }
            }
            catch (IOException ex) {
                this.reportUnexpectedError(ex);
            }
            this.collector.clear();
        }
        return false;
    }

    private void reportUnexpectedError(IOException ex) {
        String msg = ex.getClass().getSimpleName() + ": " + ex.getMessage();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }
}

