/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import internal.nbbrd.service.HasPositionHint;
import internal.nbbrd.service.provider.ProviderEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import lombok.NonNull;

final class ProviderRef
implements HasPositionHint {
    @NonNull
    private final TypeElement service;
    @NonNull
    private final TypeElement provider;

    @Override
    public Element getPositionHint() {
        return this.provider;
    }

    public String toString() {
        return this.service + "/" + this.provider;
    }

    ProviderEntry toEntry() {
        return new ProviderEntry(this.service.getQualifiedName().toString(), this.provider.getQualifiedName().toString());
    }

    static Set<ProviderRef> getDuplicates(Collection<ProviderRef> refs) {
        return refs.stream().filter(ref -> Collections.frequency(refs, ref) > 1).collect(Collectors.toSet());
    }

    @Generated
    public ProviderRef(@NonNull TypeElement service, @NonNull TypeElement provider) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.service = service;
        this.provider = provider;
    }

    @NonNull
    @Generated
    public TypeElement getService() {
        return this.service;
    }

    @NonNull
    @Generated
    public TypeElement getProvider() {
        return this.provider;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProviderRef)) {
            return false;
        }
        ProviderRef other = (ProviderRef)o;
        TypeElement this$service = this.getService();
        TypeElement other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        TypeElement this$provider = this.getProvider();
        TypeElement other$provider = other.getProvider();
        return !(this$provider == null ? other$provider != null : !this$provider.equals(other$provider));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeElement $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        TypeElement $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        return result;
    }
}

