/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.com.github.javaparser.utils;

import internal.nbbrd.service.com.github.javaparser.JavaParser;
import internal.nbbrd.service.com.github.javaparser.ParseProblemException;
import internal.nbbrd.service.com.github.javaparser.ParseResult;
import internal.nbbrd.service.com.github.javaparser.ParserConfiguration;
import internal.nbbrd.service.com.github.javaparser.ast.CompilationUnit;
import internal.nbbrd.service.com.github.javaparser.utils.Log;
import internal.nbbrd.service.com.github.javaparser.utils.ProjectRoot;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Optional;
import java.util.function.Supplier;

public interface CollectionStrategy {
    public ParserConfiguration getParserConfiguration();

    public ProjectRoot collect(Path var1);

    default public Optional<Path> getRoot(Path file) {
        try {
            JavaParser javaParser = new JavaParser(this.getParserConfiguration());
            ParseResult<CompilationUnit> parseResult = javaParser.parse(file);
            if (parseResult.isSuccessful()) {
                if (parseResult.getResult().isPresent()) {
                    Optional<Path> storage = parseResult.getResult().flatMap(CompilationUnit::getStorage);
                    if (storage.isPresent()) {
                        if (((CompilationUnit.Storage)storage.get()).getFileName().equals("module-info.java")) {
                            return Optional.empty();
                        }
                        return storage.map(CompilationUnit.Storage::getSourceRoot);
                    }
                    Log.info("Storage information not present -- an issue with providing a string rather than file reference?", new Supplier[0]);
                } else {
                    Log.info("Parse result not present", new Supplier[0]);
                }
            } else {
                Log.info("Parsing was not successful.", new Supplier[0]);
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> parseResult.getProblems().size();
                supplierArray[1] = parseResult::getProblems;
                Log.info("There were (%d) problems parsing file: %s", supplierArray);
            }
        }
        catch (ParseProblemException e) {
            Log.info("Problem parsing file %s : %s", () -> file, () -> e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            Log.info("Could not parse file %s : %s", () -> file, () -> e.getLocalizedMessage());
        }
        catch (IOException e) {
            Log.info("Could not read file %s : %s", () -> file, () -> e.getLocalizedMessage());
        }
        return Optional.empty();
    }

    default public PathMatcher getPathMatcher(String pattern) {
        return FileSystems.getDefault().getPathMatcher(pattern);
    }
}

