/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import internal.nbbrd.service.ProcessorTool;
import internal.nbbrd.service.provider.AnnotationRegistry;
import internal.nbbrd.service.provider.ProviderRef;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class ServiceProviderCollector
extends ProcessorTool {
    private final Set<Name> pendingRefs = new HashSet<Name>();

    public ServiceProviderCollector(Supplier<ProcessingEnvironment> envSupplier) {
        super(envSupplier);
    }

    public void collect(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        new AnnotationRegistry(annotations, roundEnv).readAll().forEach(ref -> this.pendingRefs.add(ref.getProvider().getQualifiedName()));
    }

    public void clear() {
        this.pendingRefs.clear();
    }

    public List<ProviderRef> build() {
        Elements elements = this.getEnv().getElementUtils();
        return this.pendingRefs.stream().map(x -> elements.getTypeElement(x.toString())).flatMap(AnnotationRegistry::newRefs).collect(Collectors.toList());
    }
}

