/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.com.github.mustachejava;

import internal.nbbrd.service.com.github.mustachejava.DefaultMustacheFactory;
import internal.nbbrd.service.com.github.mustachejava.DefaultMustacheVisitor;
import internal.nbbrd.service.com.github.mustachejava.MustacheException;
import internal.nbbrd.service.com.github.mustachejava.MustacheVisitor;
import internal.nbbrd.service.com.github.mustachejava.TemplateContext;
import internal.nbbrd.service.com.github.mustachejava.codes.ValueCode;
import internal.nbbrd.service.com.github.mustachejava.reflect.SimpleObjectHandler;
import internal.nbbrd.service.com.github.mustachejava.resolver.DefaultResolver;
import internal.nbbrd.service.com.github.mustachejava.util.HtmlEscaper;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SafeMustacheFactory
extends DefaultMustacheFactory {
    private static final Set<String> disallowedMethods = new HashSet<String>(Arrays.asList("getClass", "hashCode", "clone", "toString", "notify", "notifyAll", "finalize", "wait"));
    public static final SimpleObjectHandler OBJECT_HANDLER = new SimpleObjectHandler(){

        @Override
        protected void checkMethod(Method member) throws NoSuchMethodException {
            if (disallowedMethods.contains(member.getName())) {
                throw new MustacheException("Disallowed: method " + member.getName() + " cannot be accessed");
            }
            if ((member.getModifiers() & 1) != 1) {
                throw new NoSuchMethodException("Only public members allowed");
            }
        }

        @Override
        protected void checkField(Field member) throws NoSuchFieldException {
            if ((member.getModifiers() & 1) != 1) {
                throw new NoSuchFieldException("Only public members allowed");
            }
        }
    };

    public SafeMustacheFactory(final Set<String> allowedResourceNames, String resourceRoot) {
        super(new DefaultResolver(resourceRoot){

            @Override
            public Reader getReader(String resourceName) {
                if (allowedResourceNames.contains(resourceName)) {
                    return super.getReader(resourceName);
                }
                throw new MustacheException("Disallowed: resource requested");
            }
        });
        this.setup();
    }

    public SafeMustacheFactory(final Set<String> allowedResourceNames, File fileRoot) {
        super(new DefaultResolver(fileRoot){

            @Override
            public Reader getReader(String resourceName) {
                if (allowedResourceNames.contains(resourceName)) {
                    return super.getReader(resourceName);
                }
                throw new MustacheException("Disallowed: resource requested");
            }
        });
        this.setup();
    }

    private void setup() {
        this.setObjectHandler(OBJECT_HANDLER);
        this.mc.setAllowChangingDelimeters(false);
    }

    @Override
    public MustacheVisitor createMustacheVisitor() {
        return new DefaultMustacheVisitor(this){

            @Override
            public void pragma(TemplateContext tc, String pragma, String args) {
                throw new MustacheException("Disallowed: pragmas in templates");
            }

            @Override
            public void value(TemplateContext tc, String variable, boolean encoded) {
                if (!encoded) {
                    throw new MustacheException("Disallowed: non-encoded text in templates");
                }
                this.list.add(new ValueCode(tc, this.df, variable, encoded));
            }
        };
    }

    @Override
    public void encode(String value, Writer writer) {
        HtmlEscaper.escape(value, writer);
    }
}

