/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.jdbc;

import internal.sql.jdbc.JdbcUtil;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import nbbrd.sql.jdbc.SqlIdentifierStorageRule;
import nbbrd.sql.jdbc.SqlKeywords;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlIdentifierQuoter {
    public static final SqlIdentifierQuoter DEFAULT = SqlIdentifierQuoter.builder().build();
    @lombok.NonNull
    private final String quoteString;
    private final Set<String> sqlKeywords;
    @lombok.NonNull
    private final SqlIdentifierStorageRule unquotedStorageRule;
    @lombok.NonNull
    private final String extraNameCharacters;
    private static final String DEFAULT_IDENTIFIER_QUOTE_STRING = "\"";
    private static final String NOT_SUPPORTED_IDENTIFIER_QUOTE_STRING = " ";

    @lombok.NonNull
    public static SqlIdentifierQuoter of(@lombok.NonNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        return new SqlIdentifierQuoter(SqlIdentifierQuoter.loadIdentifierQuoteString(metaData), SqlIdentifierQuoter.loadSqlKeywords(metaData), SqlIdentifierQuoter.loadUnquotedIdentifierStorageRule(metaData), SqlIdentifierQuoter.loadExtraNameCharacters(metaData));
    }

    @lombok.NonNull
    public static Builder builder() {
        return new Builder().quoteString(DEFAULT_IDENTIFIER_QUOTE_STRING).unquotedStorageRule(SqlIdentifierStorageRule.UPPER).extraNameCharacters("");
    }

    @lombok.NonNull
    public String quote(@lombok.NonNull String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        return this.quote(identifier, false);
    }

    @lombok.NonNull
    public String quote(@lombok.NonNull String identifier, boolean force) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (this.isProperlyQuoted(identifier)) {
            return identifier;
        }
        if (force || this.isSqlKeyword(identifier) || this.containsExtraCharacters(identifier) || this.containsQuoteStrings(identifier) || this.containsSpaces(identifier) || this.breaksStorageRule(identifier)) {
            return this.quoteIdentifier(identifier);
        }
        return identifier;
    }

    private boolean isProperlyQuoted(String identifier) {
        int quoteLength;
        if (!identifier.startsWith(this.quoteString) || !identifier.endsWith(this.quoteString) || identifier.length() < this.quoteString.length() * 2) {
            return false;
        }
        int begin = quoteLength = this.quoteString.length();
        int end = identifier.length() - quoteLength;
        boolean even = true;
        while (begin < end) {
            int next = identifier.indexOf(this.quoteString, begin);
            if (next == -1 || next == end) {
                return even;
            }
            if (even) {
                even = false;
            } else if (begin == next) {
                even = true;
            } else {
                return false;
            }
            begin = next + quoteLength;
        }
        return even;
    }

    private boolean isSqlKeyword(String identifier) {
        return this.sqlKeywords.contains(SqlIdentifierQuoter.normalizeKeyword(identifier));
    }

    private boolean breaksStorageRule(String identifier) {
        return false;
    }

    private boolean containsExtraCharacters(String identifier) {
        for (int i = 0; i < identifier.length(); ++i) {
            if (this.extraNameCharacters.indexOf(identifier.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean containsQuoteStrings(String identifier) {
        return identifier.contains(this.quoteString);
    }

    private boolean containsSpaces(String identifier) {
        return identifier.contains(NOT_SUPPORTED_IDENTIFIER_QUOTE_STRING);
    }

    private String quoteIdentifier(String identifier) {
        return this.quoteString + identifier.replace(this.quoteString, this.quoteString + this.quoteString) + this.quoteString;
    }

    @lombok.NonNull
    static String loadIdentifierQuoteString(@lombok.NonNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        String identifierQuoteString = JdbcUtil.unexpectedNullToBlank(metaData.getIdentifierQuoteString(), "getIdentifierQuoteString");
        if (identifierQuoteString.equals(NOT_SUPPORTED_IDENTIFIER_QUOTE_STRING)) {
            return DEFAULT_IDENTIFIER_QUOTE_STRING;
        }
        if (SqlIdentifierQuoter.isUnexpectedIdentifierQuoteString(identifierQuoteString)) {
            return DEFAULT_IDENTIFIER_QUOTE_STRING;
        }
        return identifierQuoteString;
    }

    static boolean isUnexpectedIdentifierQuoteString(@lombok.NonNull String identifierQuoteString) {
        if (identifierQuoteString == null) {
            throw new NullPointerException("identifierQuoteString is marked non-null but is null");
        }
        return identifierQuoteString.trim().isEmpty();
    }

    @lombok.NonNull
    static Set<String> loadSqlKeywords(@lombok.NonNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        return Stream.concat(SqlIdentifierQuoter.getSpecificKeywords(metaData), SqlIdentifierQuoter.getStandardKeywords(metaData)).collect(Collectors.toSet());
    }

    @lombok.NonNull
    static Stream<String> getSpecificKeywords(@lombok.NonNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        String specificKeywords = JdbcUtil.unexpectedNullToBlank(metaData.getSQLKeywords(), "getSQLKeywords");
        return SqlIdentifierQuoter.getSpecificKeywords(specificKeywords);
    }

    @lombok.NonNull
    static Stream<String> getStandardKeywords(@lombok.NonNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        return SqlKeywords.LATEST_RESERVED_WORDS.getKeywords().stream();
    }

    @lombok.NonNull
    static Stream<String> getSpecificKeywords(@lombok.NonNull CharSequence input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return JdbcUtil.splitToStream(',', input).map(String::trim).filter(o -> !o.isEmpty()).map(SqlIdentifierQuoter::normalizeKeyword);
    }

    @lombok.NonNull
    static String normalizeKeyword(String input) {
        return input.toUpperCase(Locale.ROOT);
    }

    @lombok.NonNull
    static String loadExtraNameCharacters(@lombok.NonNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        return JdbcUtil.unexpectedNullToBlank(metaData.getExtraNameCharacters(), "getExtraNameCharacters");
    }

    @lombok.NonNull
    static SqlIdentifierStorageRule loadUnquotedIdentifierStorageRule(@lombok.NonNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        if (metaData.storesUpperCaseIdentifiers()) {
            return SqlIdentifierStorageRule.UPPER;
        }
        if (metaData.storesLowerCaseIdentifiers()) {
            return SqlIdentifierStorageRule.LOWER;
        }
        if (metaData.storesMixedCaseIdentifiers()) {
            return SqlIdentifierStorageRule.MIXED;
        }
        return SqlIdentifierStorageRule.UPPER;
    }

    @Generated
    SqlIdentifierQuoter(@lombok.NonNull String quoteString, Set<String> sqlKeywords, @lombok.NonNull SqlIdentifierStorageRule unquotedStorageRule, @lombok.NonNull String extraNameCharacters) {
        if (quoteString == null) {
            throw new NullPointerException("quoteString is marked non-null but is null");
        }
        if (unquotedStorageRule == null) {
            throw new NullPointerException("unquotedStorageRule is marked non-null but is null");
        }
        if (extraNameCharacters == null) {
            throw new NullPointerException("extraNameCharacters is marked non-null but is null");
        }
        this.quoteString = quoteString;
        this.sqlKeywords = sqlKeywords;
        this.unquotedStorageRule = unquotedStorageRule;
        this.extraNameCharacters = extraNameCharacters;
    }

    @lombok.NonNull
    @Generated
    public String getQuoteString() {
        return this.quoteString;
    }

    @Generated
    public Set<String> getSqlKeywords() {
        return this.sqlKeywords;
    }

    @lombok.NonNull
    @Generated
    public SqlIdentifierStorageRule getUnquotedStorageRule() {
        return this.unquotedStorageRule;
    }

    @lombok.NonNull
    @Generated
    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlIdentifierQuoter)) {
            return false;
        }
        SqlIdentifierQuoter other = (SqlIdentifierQuoter)o;
        String this$quoteString = this.getQuoteString();
        String other$quoteString = other.getQuoteString();
        if (this$quoteString == null ? other$quoteString != null : !this$quoteString.equals(other$quoteString)) {
            return false;
        }
        Set<String> this$sqlKeywords = this.getSqlKeywords();
        Set<String> other$sqlKeywords = other.getSqlKeywords();
        if (this$sqlKeywords == null ? other$sqlKeywords != null : !((Object)this$sqlKeywords).equals(other$sqlKeywords)) {
            return false;
        }
        SqlIdentifierStorageRule this$unquotedStorageRule = this.getUnquotedStorageRule();
        SqlIdentifierStorageRule other$unquotedStorageRule = other.getUnquotedStorageRule();
        if (this$unquotedStorageRule == null ? other$unquotedStorageRule != null : !((Object)((Object)this$unquotedStorageRule)).equals((Object)other$unquotedStorageRule)) {
            return false;
        }
        String this$extraNameCharacters = this.getExtraNameCharacters();
        String other$extraNameCharacters = other.getExtraNameCharacters();
        return !(this$extraNameCharacters == null ? other$extraNameCharacters != null : !this$extraNameCharacters.equals(other$extraNameCharacters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $quoteString = this.getQuoteString();
        result = result * 59 + ($quoteString == null ? 43 : $quoteString.hashCode());
        Set<String> $sqlKeywords = this.getSqlKeywords();
        result = result * 59 + ($sqlKeywords == null ? 43 : ((Object)$sqlKeywords).hashCode());
        SqlIdentifierStorageRule $unquotedStorageRule = this.getUnquotedStorageRule();
        result = result * 59 + ($unquotedStorageRule == null ? 43 : ((Object)((Object)$unquotedStorageRule)).hashCode());
        String $extraNameCharacters = this.getExtraNameCharacters();
        result = result * 59 + ($extraNameCharacters == null ? 43 : $extraNameCharacters.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SqlIdentifierQuoter(quoteString=" + this.getQuoteString() + ", sqlKeywords=" + this.getSqlKeywords() + ", unquotedStorageRule=" + (Object)((Object)this.getUnquotedStorageRule()) + ", extraNameCharacters=" + this.getExtraNameCharacters() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String quoteString;
        @Generated
        private ArrayList<String> sqlKeywords;
        @Generated
        private SqlIdentifierStorageRule unquotedStorageRule;
        @Generated
        private String extraNameCharacters;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder quoteString(@lombok.NonNull String quoteString) {
            if (quoteString == null) {
                throw new NullPointerException("quoteString is marked non-null but is null");
            }
            this.quoteString = quoteString;
            return this;
        }

        @Generated
        public @NonNull Builder sqlKeyword(String sqlKeyword) {
            if (this.sqlKeywords == null) {
                this.sqlKeywords = new ArrayList();
            }
            this.sqlKeywords.add(sqlKeyword);
            return this;
        }

        @Generated
        public @NonNull Builder sqlKeywords(@NonNull Collection<? extends String> sqlKeywords) {
            if (sqlKeywords == null) {
                throw new NullPointerException("sqlKeywords cannot be null");
            }
            if (this.sqlKeywords == null) {
                this.sqlKeywords = new ArrayList();
            }
            this.sqlKeywords.addAll(sqlKeywords);
            return this;
        }

        @Generated
        public @NonNull Builder clearSqlKeywords() {
            if (this.sqlKeywords != null) {
                this.sqlKeywords.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Builder unquotedStorageRule(@lombok.NonNull SqlIdentifierStorageRule unquotedStorageRule) {
            if (unquotedStorageRule == null) {
                throw new NullPointerException("unquotedStorageRule is marked non-null but is null");
            }
            this.unquotedStorageRule = unquotedStorageRule;
            return this;
        }

        @Generated
        public @NonNull Builder extraNameCharacters(@lombok.NonNull String extraNameCharacters) {
            if (extraNameCharacters == null) {
                throw new NullPointerException("extraNameCharacters is marked non-null but is null");
            }
            this.extraNameCharacters = extraNameCharacters;
            return this;
        }

        @Generated
        public @NonNull SqlIdentifierQuoter build() {
            Set<String> sqlKeywords;
            switch (this.sqlKeywords == null ? 0 : this.sqlKeywords.size()) {
                case 0: {
                    sqlKeywords = Collections.emptySet();
                    break;
                }
                case 1: {
                    sqlKeywords = Collections.singleton(this.sqlKeywords.get(0));
                    break;
                }
                default: {
                    sqlKeywords = new LinkedHashSet(this.sqlKeywords.size() < 0x40000000 ? 1 + this.sqlKeywords.size() + (this.sqlKeywords.size() - 3) / 3 : Integer.MAX_VALUE);
                    sqlKeywords.addAll(this.sqlKeywords);
                    sqlKeywords = Collections.unmodifiableSet(sqlKeywords);
                }
            }
            return new SqlIdentifierQuoter(this.quoteString, sqlKeywords, this.unquotedStorageRule, this.extraNameCharacters);
        }

        @Generated
        public @NonNull String toString() {
            return "SqlIdentifierQuoter.Builder(quoteString=" + this.quoteString + ", sqlKeywords=" + this.sqlKeywords + ", unquotedStorageRule=" + (Object)((Object)this.unquotedStorageRule) + ", extraNameCharacters=" + this.extraNameCharacters + ")";
        }
    }
}

