/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.algorithms;

import com.buck.commons.algorithms.MersenneTwister;
import java.util.Random;
import java.util.UUID;

public final class UUIDFactory {
    private static final ThreadLocal<Random> tssPRNG = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new MersenneTwister();
        }
    };

    public static UUID randomUUID() {
        int i;
        byte[] randomBytes = new byte[16];
        tssPRNG.get().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

