/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.i18n;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ISO8601DateTime {
    public static final String ISO_8601_EXTENDED_PATTERN_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final ThreadLocal<SimpleDateFormat> tssStandardDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat(ISO8601DateTime.ISO_8601_EXTENDED_PATTERN_Z);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };

    public static Date toDate(String iso8601Date) throws ParseException {
        return tssStandardDateFormat.get().parse(iso8601Date);
    }

    public static String fromDate(Date date) {
        return tssStandardDateFormat.get().format(date);
    }
}

