/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.net;

import com.buck.commons.algorithms.HashCode;
import com.buck.commons.i18n.ResourceBundle;
import com.buck.commons.net.URNSyntaxException;

public class URN
implements Comparable<URN> {
    private String pre;
    private String nid;
    private String nss;
    private int hash;
    private static final long L_DIGIT = URN.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = URN.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = URN.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_HYPHEN = URN.lowMask("-");
    private static final long H_HYPHEN = URN.highMask("-");
    private static final long L_ALPHANUM_HYPHEN = L_ALPHANUM | L_HYPHEN;
    private static final long H_ALPHANUM_HYPHEN = H_ALPHANUM | H_HYPHEN;
    private static final long L_HEX = L_DIGIT;
    private static final long H_HEX = URN.highMask('A', 'F') | URN.highMask('a', 'f');
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_OTHER = URN.lowMask("()+,-.:=@;$_!*'");
    private static final long H_OTHER = URN.highMask("()+,-.:=@;$_!*'");
    private static final long L_RESERVED = URN.lowMask("%/?#");
    private static final long H_RESERVED = URN.highMask("%/?#");
    private static final long L_TRANS = L_ALPHANUM | L_OTHER | L_RESERVED;
    private static final long H_TRANS = H_ALPHANUM | H_OTHER | H_RESERVED;

    private static long lowMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c >= '@') continue;
            m |= 1L << c;
        }
        return m;
    }

    private static long highMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            m |= 1L << c - 64;
        }
        return m;
    }

    private static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static long highMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 127), 64) - 64;
        int l = Math.max(Math.min(last, 127), 64) - 64;
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    public URN(String urn) throws URNSyntaxException {
        new Parser(urn).parse();
    }

    public String getUrn() {
        return this.pre + ":" + this.nid + ":" + this.nss;
    }

    public String getNid() {
        return this.nid;
    }

    public String getNss() {
        return this.nss;
    }

    public String toString() {
        return this.getUrn();
    }

    private static int toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c + 32;
        }
        return c;
    }

    private static int compareIgnoringCase(String s, String t) {
        int tn;
        if (s.equals(t)) {
            return 0;
        }
        int sn = s.length();
        int n = sn < (tn = t.length()) ? sn : tn;
        for (int i = 0; i < n; ++i) {
            int c = URN.toLower(s.charAt(i)) - URN.toLower(t.charAt(i));
            if (c == 0) continue;
            return c;
        }
        return sn - tn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof URN) {
            URN that = (URN)obj;
            return this.compareTo(that) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(URN that) {
        int c = URN.compareIgnoringCase(this.pre, that.pre);
        if (c != 0) {
            return c;
        }
        c = URN.compareIgnoringCase(this.nid, that.nid);
        if (c != 0) {
            return c;
        }
        c = URN.compareIgnoringCase(this.nss, that.nss);
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = HashCode.hashCode(this.pre, this.nid, this.nss);
        }
        return h;
    }

    private class Parser {
        final String input;

        Parser(String s) {
            this.input = s;
        }

        void parse() throws URNSyntaxException {
            int n = this.input.length();
            int p = this.scan(0, n, ",", ":");
            if (p >= 0 && this.at(p, n, ':')) {
                String message;
                Object[] arguments;
                if (p == 0) {
                    arguments = new Object[]{this.input};
                    message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_MISSING_PREFIX", arguments);
                    this.fail(message, p);
                }
                URN.this.pre = this.substring(0, p).toLowerCase();
                if (!"urn".equals(URN.this.pre)) {
                    arguments = new Object[]{this.input};
                    message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_INVALID_PREFIX", arguments);
                    this.fail(message);
                }
                ++p;
                p = this.parseNID(p, n);
            } else {
                Object[] arguments = new Object[]{this.input};
                String message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_NOT_URN", arguments);
                this.fail(message, p);
            }
            assert (p == n);
        }

        private int parseNID(int p, int n) throws URNSyntaxException {
            int q = this.scan(p, n, ",", ":");
            if (q >= p && this.at(q, n, ':')) {
                String message;
                Object[] arguments;
                if (q == p) {
                    arguments = new Object[]{};
                    message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_NID_TOO_SHORT", arguments);
                    this.fail(message, q);
                }
                if (q - p > 32) {
                    arguments = new Object[]{this.input};
                    message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_NID_TOO_LONG", arguments);
                    this.fail(message);
                }
                this.checkChar(p, L_ALPHANUM, H_ALPHANUM, "namespace identifier");
                this.checkChars(p, q, L_ALPHANUM_HYPHEN, H_ALPHANUM_HYPHEN, "namespace identifier");
                URN.this.nid = this.substring(p, q);
                p = q + 1;
                p = this.parseNSS(p, n);
            } else {
                Object[] arguments = new Object[]{this.input};
                String message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_NID_ILLEGAL", arguments);
                this.fail(message, q);
            }
            return p;
        }

        private int parseNSS(int p, int n) throws URNSyntaxException {
            int q = this.scan(p, n, L_ALPHANUM | L_OTHER | 1L, H_ALPHANUM | H_OTHER | 0L);
            if (p < n) {
                this.checkChars(p, n, L_TRANS, H_TRANS, "namespace specific string");
                URN.this.nss = this.substring(p, n);
            } else {
                Object[] arguments = new Object[]{this.input};
                String message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_NSS_TOO_SHORT", arguments);
                this.fail(message, p);
            }
            return n;
        }

        private void fail(String reason) throws URNSyntaxException {
            throw new URNSyntaxException(this.input, reason);
        }

        private void fail(String reason, int p) throws URNSyntaxException {
            throw new URNSyntaxException(this.input, reason, p);
        }

        private int scanEscape(int p, int n, char c) throws URNSyntaxException {
            if (c == '%') {
                if (p + 3 <= n && URN.match(this.charAt(p + 1), L_HEX, H_HEX) && URN.match(this.charAt(p + 2), L_HEX, H_HEX)) {
                    return p + 3;
                }
                Object[] arguments = new Object[]{};
                String message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_MALFORMED_ESCAPE", arguments);
                this.fail(message, p);
            }
            return p;
        }

        private int scan(int start, int n, long lowMask, long highMask) throws URNSyntaxException {
            int p = start;
            while (p < n) {
                int q;
                char c = this.charAt(p);
                if (URN.match(c, lowMask, highMask)) {
                    ++p;
                    continue;
                }
                if ((lowMask & 1L) == 0L || (q = this.scanEscape(p, n, c)) <= p) break;
                p = q;
            }
            return p;
        }

        private void checkChars(int start, int end, long lowMask, long highMask, String what) throws URNSyntaxException {
            int p = this.scan(start, end, lowMask, highMask);
            if (p < end) {
                Object[] arguments = new Object[]{what};
                String message = ResourceBundle.formatResourceBundleMessage(URN.class, "URN_ILLEGAL_CHARACTER", arguments);
                this.fail(message, p);
            }
        }

        private void checkChar(int p, long lowMask, long highMask, String what) throws URNSyntaxException {
            this.checkChars(p, p + 1, lowMask, highMask, what);
        }

        private int scan(int start, int end, String err, String stop) {
            char c;
            int p;
            for (p = start; p < end && err.indexOf(c = this.charAt(p)) < 0 && stop.indexOf(c) < 0; ++p) {
            }
            return p;
        }

        private boolean at(int start, int end, char c) {
            return start < end && this.charAt(start) == c;
        }

        private char charAt(int p) {
            return this.input.charAt(p);
        }

        private String substring(int start, int end) {
            return this.input.substring(start, end);
        }
    }
}

