/*
 * Decompiled with CFR 0.152.
 */
package org.basicmon.sync;

import java.util.concurrent.Callable;
import org.basicmon.BasicTimer;
import org.basicmon.BasicTimerSplit;
import org.basicmon.BasicTimerStats;
import org.basicmon.sync.BasicMonSyncBase;
import org.basicmon.util.BasicMonUtil;
import org.basicmon.util.BasicTimerUtil;

public final class BasicTimerSyncImpl<V>
extends BasicMonSyncBase
implements BasicTimer<V> {
    private int active;
    private long activeTotal;
    private long activeCounter;
    private BasicTimerStats basicTimerStats;

    public BasicTimerSyncImpl(String id) {
        super(id, false);
    }

    public BasicTimerSyncImpl(String id, boolean withStats) {
        super(id, withStats);
        if (withStats) {
            try {
                this.basicTimerStats = new BasicTimerStats();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void reset() {
        this.active = 0;
        this.activeTotal = 0L;
        this.activeCounter = 0L;
        super.reset();
    }

    @Override
    public BasicTimerSplit start() {
        this.updateActive();
        return new BasicTimerSplit(this, System.nanoTime());
    }

    @Override
    public long stop(BasicTimerSplit split) {
        long splitTime = System.nanoTime() - split.getStartTime();
        this.updateSplit(splitTime);
        return splitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V doInTimer(Callable<V> function) throws Exception {
        BasicTimerSplit split = this.start();
        try {
            V v = function.call();
            return v;
        }
        finally {
            split.stop();
        }
    }

    @Override
    public void addTime(long time) {
        this.updateSplit(time);
    }

    @Override
    public synchronized int getActive() {
        return this.active;
    }

    @Override
    public synchronized double getActiveMean() {
        return (double)this.activeTotal / (double)this.activeCounter;
    }

    @Override
    public long getActiveMax() {
        return this.withStats ? this.basicTimerStats.getActiveMax() : -1L;
    }

    @Override
    public double getActiveVariance() {
        return this.withStats ? this.basicTimerStats.getActiveVariance() : -1.0;
    }

    @Override
    public synchronized double getActiveStdDev() {
        if (!this.withStats) {
            return -1.0;
        }
        double variance = this.getActiveVariance();
        long counter = this.getVal();
        return BasicMonUtil.calcStdDev(variance, counter);
    }

    public String toString() {
        return BasicTimerUtil.toString(this);
    }

    private synchronized void updateActive() {
        int currentActive = ++this.active;
        if (this.withStats) {
            this.basicTimerStats.updateActiveStats(currentActive);
        }
        this.activeTotal += (long)currentActive;
        ++this.activeCounter;
    }

    private synchronized void updateSplit(long splitTime) {
        --this.active;
        super.setVal(splitTime);
    }
}

