/*
 * Decompiled with CFR 0.152.
 */
package org.basicmon.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class BasicMonUtil {
    private static final int UNIT_PREFIX_FACTOR = 1000;
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final int TEN = 10;
    private static final DecimalFormat UNDER_TEN_FORMAT = new DecimalFormat("0.00", DECIMAL_FORMAT_SYMBOLS);
    private static final int HUNDRED = 100;
    private static final DecimalFormat UNDER_HUNDRED_FORMAT = new DecimalFormat("00.0", DECIMAL_FORMAT_SYMBOLS);
    private static final DecimalFormat DEFAULT_FORMAT = new DecimalFormat("000", DECIMAL_FORMAT_SYMBOLS);
    private static final String UNDEF_STRING = "undef";

    public static double calcStdDev(double variance, long counter) {
        double stdDev = Double.NaN;
        if (counter > 0L) {
            stdDev = counter > 1L ? Math.sqrt(variance) : 0.0;
        }
        return stdDev;
    }

    public static String formatDecimal(double decimal) {
        if (Double.isNaN(decimal)) {
            return "NA";
        }
        if (Double.isInfinite(decimal)) {
            return "Inf";
        }
        if (decimal < 10.0) {
            return UNDER_TEN_FORMAT.format(decimal);
        }
        if (decimal < 100.0) {
            return UNDER_HUNDRED_FORMAT.format(decimal);
        }
        return DEFAULT_FORMAT.format(decimal);
    }

    public static String formatTime(double time, String unit) {
        if (time < 10.0) {
            return UNDER_TEN_FORMAT.format(time) + unit;
        }
        if (time < 100.0) {
            return UNDER_HUNDRED_FORMAT.format(time) + unit;
        }
        return DEFAULT_FORMAT.format(time) + unit;
    }

    public static String presentNanoTime(double nanos) {
        if (Double.isInfinite(nanos)) {
            return "Inf";
        }
        if (Double.isNaN(nanos)) {
            return "NA";
        }
        return BasicMonUtil.presentNanoTime((long)nanos);
    }

    public static String presentNanoTime(long nanos) {
        if (nanos == Long.MAX_VALUE) {
            return UNDEF_STRING;
        }
        if (nanos < 1000L) {
            return nanos + " ns";
        }
        double time = nanos;
        if ((time /= 1000.0) < 1000.0) {
            return BasicMonUtil.formatTime(time, " us");
        }
        if ((time /= 1000.0) < 1000.0) {
            return BasicMonUtil.formatTime(time, " ms");
        }
        return BasicMonUtil.formatTime(time /= 1000.0, " s");
    }
}

