/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;

public class FacebookApi
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://www.facebook.com/v2.5/dialog/oauth?client_id=%s&redirect_uri=%s";

    protected FacebookApi() {
    }

    public static FacebookApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public Verb getAccessTokenVerb() {
        return Verb.GET;
    }

    public String getAccessTokenEndpoint() {
        return "https://graph.facebook.com/v2.5/oauth/access_token";
    }

    public String getRefreshTokenEndpoint() {
        throw new UnsupportedOperationException("Facebook doesn't support refershing tokens");
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        String state;
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. Facebook does not support OOB");
        StringBuilder sb = new StringBuilder(String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback())));
        if (config.hasScope()) {
            sb.append('&').append("scope").append('=').append(OAuthEncoder.encode((String)config.getScope()));
        }
        if ((state = config.getState()) != null) {
            sb.append('&').append("state").append('=').append(OAuthEncoder.encode((String)state));
        }
        return sb.toString();
    }

    private static class InstanceHolder {
        private static final FacebookApi INSTANCE = new FacebookApi();

        private InstanceHolder() {
        }
    }
}

