/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder;

import com.github.scribejava.core.builder.AbstractServiceBuilder;
import com.github.scribejava.core.model.OAuthConfigAsync;
import com.github.scribejava.core.utils.Preconditions;
import com.ning.http.client.AsyncHttpClientConfig;

public class ServiceBuilderAsync
extends AbstractServiceBuilder<ServiceBuilderAsync> {
    private AsyncHttpClientConfig asyncHttpClientConfig;
    private String asyncHttpProviderClassName;

    public ServiceBuilderAsync asyncHttpClientConfig(AsyncHttpClientConfig asyncHttpClientConfig) {
        Preconditions.checkNotNull(asyncHttpClientConfig, "asyncHttpClientConfig can't be null");
        this.asyncHttpClientConfig = asyncHttpClientConfig;
        return this;
    }

    @Override
    public void checkPreconditions() {
        super.checkPreconditions();
        Preconditions.checkNotNull(this.asyncHttpClientConfig, "You must provide an asyncHttpClientConfig");
    }

    @Override
    protected OAuthConfigAsync createConfig() {
        this.checkPreconditions();
        OAuthConfigAsync configAsync = new OAuthConfigAsync(this.getApiKey(), this.getApiSecret(), this.getCallback(), this.getSignatureType(), this.getScope(), this.getGrantType(), this.getDebugStream(), this.asyncHttpClientConfig);
        configAsync.setState(this.getState());
        configAsync.setAsyncHttpProviderClassName(this.asyncHttpProviderClassName);
        return configAsync;
    }

    public ServiceBuilderAsync asyncHttpProviderClassName(String asyncHttpProviderClassName) {
        this.asyncHttpProviderClassName = asyncHttpProviderClassName;
        return this;
    }
}

