/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.exceptions.OAuthConnectionException;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.ForceTypeOfHttpRequest;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.ScribeJavaConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuthService;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class OAuthRequest
extends AbstractRequest {
    private HttpURLConnection connection;
    private final OAuthConfig config;

    @Deprecated
    public OAuthRequest(Verb verb, String url, OAuthService<?> service) {
        this(verb, url, service.getConfig());
    }

    public OAuthRequest(Verb verb, String url, OAuthConfig config) {
        super(verb, url);
        this.config = config;
    }

    public Response send() {
        ForceTypeOfHttpRequest forceTypeOfHttpRequest = ScribeJavaConfig.getForceTypeOfHttpRequests();
        if (ForceTypeOfHttpRequest.FORCE_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
            throw new OAuthException("Cannot use sync operations, only async");
        }
        if (ForceTypeOfHttpRequest.PREFER_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
            this.config.log("Cannot use sync operations, only async");
        }
        try {
            this.createConnection();
            return this.doSend();
        }
        catch (IOException | RuntimeException e) {
            throw new OAuthConnectionException(this.getCompleteUrl(), e);
        }
    }

    Response doSend() throws IOException {
        Verb verb = this.getVerb();
        this.connection.setRequestMethod(verb.name());
        if (this.config.getConnectTimeout() != null) {
            this.connection.setConnectTimeout(this.config.getConnectTimeout());
        }
        if (this.config.getReadTimeout() != null) {
            this.connection.setReadTimeout(this.config.getReadTimeout());
        }
        this.addHeaders();
        if (this.hasBodyContent()) {
            File filePayload = this.getFilePayload();
            if (filePayload != null) {
                throw new UnsupportedOperationException("Sync Requests do not support File payload for the moment");
            }
            if (this.getStringPayload() != null) {
                this.addBody(this.getStringPayload().getBytes(this.getCharset()));
            } else {
                this.addBody(this.getByteArrayPayload());
            }
        }
        return new Response(this.connection);
    }

    private void createConnection() throws IOException {
        String completeUrl = this.getCompleteUrl();
        if (this.connection == null) {
            this.connection = (HttpURLConnection)new URL(completeUrl).openConnection();
            this.connection.setInstanceFollowRedirects(this.isFollowRedirects());
        }
    }

    void addHeaders() {
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            this.connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        String userAgent = this.config.getUserAgent();
        if (userAgent != null) {
            this.connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    void addBody(byte[] content) throws IOException {
        this.connection.setRequestProperty("Content-Length", String.valueOf(content.length));
        if (this.connection.getRequestProperty("Content-Type") == null) {
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        this.connection.setDoOutput(true);
        this.connection.getOutputStream().write(content);
    }

    void setConnection(HttpURLConnection connection) {
        this.connection = connection;
    }
}

