/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Response {
    private final int code;
    private final String message;
    private final Map<String, String> headers;
    private String body;
    private InputStream stream;

    @Deprecated
    public Response(int code, String message, Map<String, String> headers, String body, InputStream stream) {
        this.code = code;
        this.message = message;
        this.headers = headers;
        this.body = body;
        this.stream = stream;
    }

    private Response(int code, String message, Map<String, String> headers) {
        this.code = code;
        this.message = message;
        this.headers = headers;
    }

    public Response(int code, String message, Map<String, String> headers, InputStream stream) {
        this(code, message, headers);
        this.stream = stream;
    }

    public Response(int code, String message, Map<String, String> headers, String body) {
        this(code, message, headers);
        this.body = body;
    }

    @Deprecated
    Response(HttpURLConnection connection) throws IOException {
        try {
            connection.connect();
            this.code = connection.getResponseCode();
            this.message = connection.getResponseMessage();
            this.headers = this.parseHeaders(connection);
            this.stream = this.isSuccessful() ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (UnknownHostException e) {
            throw new OAuthException("The IP address of a host could not be determined.", e);
        }
    }

    private String parseBodyContents() throws IOException {
        if (this.stream == null) {
            return null;
        }
        this.body = "gzip".equals(this.getHeader("Content-Encoding")) ? StreamUtils.getGzipStreamContents(this.stream) : StreamUtils.getStreamContents(this.stream);
        return this.body;
    }

    @Deprecated
    private Map<String, String> parseHeaders(HttpURLConnection conn) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            String key = entry.getKey();
            if ("Content-Encoding".equalsIgnoreCase(key)) {
                headers.put("Content-Encoding", entry.getValue().get(0));
                continue;
            }
            headers.put(key, entry.getValue().get(0));
        }
        return headers;
    }

    public final boolean isSuccessful() {
        return this.code >= 200 && this.code < 400;
    }

    public String getBody() throws IOException {
        return this.body == null ? this.parseBodyContents() : this.body;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public final int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public String toString() {
        return "Response{code=" + this.code + ", message='" + this.message + '\'' + ", body='" + this.body + '\'' + ", headers=" + this.headers + '}';
    }
}

