/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuthRequestTest {
    private OAuthRequest request;

    @Before
    public void setUp() {
        this.request = new OAuthRequest(Verb.GET, "http://example.com");
    }

    @Test
    public void shouldAddOAuthParamters() {
        this.request.addOAuthParameter("oauth_token", "token");
        this.request.addOAuthParameter("oauth_nonce", "nonce");
        this.request.addOAuthParameter("oauth_timestamp", "ts");
        this.request.addOAuthParameter("scope", "feeds");
        this.request.addOAuthParameter("realm", "some-realm");
        Assert.assertEquals((long)5L, (long)this.request.getOauthParameters().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfParameterIsNotOAuth() {
        this.request.addOAuthParameter("otherParam", "value");
    }
}

