/*
 * Decompiled with CFR 0.152.
 */
package io.github.stephenc.diffpatch;

import difflib.DiffUtils;
import difflib.Patch;
import difflib.PatchFailedException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="apply", threadSafe=true)
public class ApplyMojo
extends AbstractMojo {
    @Parameter(defaultValue="src/main/patches")
    private File patchDirectory;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] patches = this.patchDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".patch");
            }
        });
        if (patches == null) {
            return;
        }
        for (File p : patches) {
            List lines;
            try {
                lines = FileUtils.readLines((File)p, (String)this.encoding);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Could not read %s", p), (Exception)e);
            }
            ArrayList<String> diff = new ArrayList<String>(lines.size());
            String oldFile = null;
            String newFile = null;
            block12: for (String line : lines) {
                int endIndex;
                if (newFile == null && line.startsWith("+++ ")) {
                    endIndex = line.indexOf(4, 9);
                    newFile = line.substring(4, endIndex == -1 ? line.length() : endIndex);
                    diff.add(line);
                    continue;
                }
                if (oldFile == null && line.startsWith("--- ")) {
                    endIndex = line.indexOf(4, 9);
                    oldFile = line.substring(4, endIndex == -1 ? line.length() : endIndex);
                    continue;
                }
                if (!line.isEmpty()) {
                    switch (line.charAt(0)) {
                        case ' ': 
                        case '+': 
                        case '-': 
                        case '@': {
                            diff.add(line);
                            continue block12;
                        }
                    }
                }
                if (!diff.isEmpty()) {
                    Patch patch = DiffUtils.parseUnifiedDiff(diff);
                    try {
                        this.getLog().info((CharSequence)String.format("Patching %s to %s", oldFile, newFile));
                        FileUtils.writeLines((File)new File(newFile), (String)this.encoding, (Collection)patch.applyTo(FileUtils.readLines((File)new File(oldFile), (String)this.encoding)));
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Could not apply patch", (Exception)e);
                    }
                    catch (PatchFailedException e) {
                        throw new MojoExecutionException("Could not apply patch", (Exception)((Object)e));
                    }
                }
                diff.clear();
                oldFile = null;
                newFile = null;
            }
            if (diff.isEmpty()) continue;
            Patch patch = DiffUtils.parseUnifiedDiff(diff);
            try {
                this.getLog().info((CharSequence)String.format("Patching %s to %s", oldFile, newFile));
                FileUtils.writeLines((File)new File(newFile), (String)this.encoding, (Collection)patch.applyTo(FileUtils.readLines((File)new File(oldFile), (String)this.encoding)));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not apply patch", (Exception)e);
            }
            catch (PatchFailedException e) {
                throw new MojoExecutionException("Could not apply patch", (Exception)((Object)e));
            }
        }
    }
}

