/*
 * Decompiled with CFR 0.152.
 */
package cz.advel.stack.instrument;

import cz.advel.stack.Stack;
import cz.advel.stack.StaticAlloc;
import cz.advel.stack.instrument.InstrumentClass;
import cz.advel.stack.instrument.Instrumenter;
import cz.advel.stack.instrument.StackGenerator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

class InstrumentMethod
extends MethodNode {
    private static String STACK_NAME = Type.getInternalName(Stack.class);
    private static String STACK_ALLOC_CLASS_DESC = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Class.class)});
    private static String STACK_ALLOC_OBJECT_DESC = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class)});
    private static String STATIC_ALLOC_DESC = Type.getDescriptor(StaticAlloc.class);
    private static String CONTINUATIONS_SUSPEND_EXECUTION_NAME = "de/matthiasmann/continuations/SuspendExecution";
    private Instrumenter instr;
    private InstrumentClass inscls;
    private String className;
    private ClassVisitor cv;
    private List<Frame> frames;
    private boolean disableAllocation;
    private boolean staticAllocation = false;
    boolean emitMethod = true;

    public InstrumentMethod(int access, String name, String desc, String signature, String[] exceptions, Instrumenter instr, InstrumentClass inscls, String className, ClassVisitor cv) {
        super(access, name, desc, signature, exceptions);
        this.instr = instr;
        this.inscls = inscls;
        this.className = className;
        this.cv = cv;
        this.disableAllocation = instr.isDisabled();
    }

    public void visitEnd() {
        try {
            int i;
            for (i = 0; i < this.exceptions.size(); ++i) {
                String exceptionName = (String)this.exceptions.get(i);
                if (!exceptionName.equals(CONTINUATIONS_SUSPEND_EXECUTION_NAME)) continue;
                this.disableAllocation = true;
            }
            if (this.invisibleAnnotations != null) {
                for (i = 0; i < this.invisibleAnnotations.size(); ++i) {
                    AnnotationNode an = (AnnotationNode)this.invisibleAnnotations.get(i);
                    if (!an.desc.equals(STATIC_ALLOC_DESC)) continue;
                    if (this.instr.isSingleThread()) {
                        this.staticAllocation = true;
                    }
                    this.invisibleAnnotations.remove(i);
                    break;
                }
            }
            int stackVar = this.maxLocals;
            Analyzer analyzer = new Analyzer((Interpreter)new SimpleVerifier());
            analyzer.analyze(this.className, (MethodNode)this);
            this.frames = new ArrayList<Frame>(Arrays.asList(analyzer.getFrames()));
            HashSet<String> usedTypes = new HashSet<String>();
            boolean createStack = false;
            AbstractInsnNode insn = this.instructions.getFirst();
            while (insn != null) {
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode min = (MethodInsnNode)insn;
                    if (min.owner.equals(STACK_NAME) && min.name.equals("alloc") && min.desc.equals(STACK_ALLOC_CLASS_DESC)) {
                        TypeInsnNode tin;
                        AbstractInsnNode insnBefore = min.getPrevious();
                        Type type = null;
                        if (insnBefore instanceof LdcInsnNode && ((LdcInsnNode)insnBefore).cst instanceof Type) {
                            type = (Type)((LdcInsnNode)insnBefore).cst;
                            this.removeInsn(insnBefore);
                        } else {
                            this.logError("first parameter of Stack.alloc(Class) must be constant");
                        }
                        if (!this.staticAllocation) {
                            usedTypes.add(type.getInternalName());
                            this.instr.addStackType(type.getInternalName());
                        }
                        insn = this.replaceAllocClass(insn, type, stackVar).getNext();
                        this.removeInsn((AbstractInsnNode)min);
                        if (!(insn instanceof TypeInsnNode) || (tin = (TypeInsnNode)insn).getOpcode() != 192 || !tin.desc.equals(type.getInternalName())) continue;
                        insn = insn.getNext();
                        this.removeInsn((AbstractInsnNode)tin);
                        continue;
                    }
                    if (min.owner.equals(STACK_NAME) && min.name.equals("alloc") && min.desc.equals(STACK_ALLOC_OBJECT_DESC)) {
                        TypeInsnNode tin;
                        Frame frame = this.frames.get(this.instructions.indexOf(insn));
                        BasicValue value = (BasicValue)frame.getStack(frame.getStackSize() - 1);
                        Type type = value.getType();
                        if (!this.staticAllocation) {
                            usedTypes.add(type.getInternalName());
                            this.instr.addStackType(type.getInternalName());
                        }
                        insn = this.replaceAllocObject(insn, type, stackVar).getNext();
                        this.removeInsn((AbstractInsnNode)min);
                        if (!(insn instanceof TypeInsnNode) || (tin = (TypeInsnNode)insn).getOpcode() != 192 || !tin.desc.equals(type.getInternalName())) continue;
                        insn = insn.getNext();
                        this.removeInsn((AbstractInsnNode)tin);
                        continue;
                    }
                    if (min.owner.equals(STACK_NAME) && min.name.equals("libraryCleanCurrentThread") && min.desc.equals("()V")) {
                        if (this.instr.isDisabled() || this.instr.isSingleThread()) {
                            insn = insn.getNext();
                            this.removeInsn((AbstractInsnNode)min);
                            continue;
                        }
                        insn = this.insertInsn(insn, (AbstractInsnNode)new FieldInsnNode(178, this.instr.getStackInternalName(), "threadLocal", "Ljava/lang/ThreadLocal;"));
                        insn = this.insertInsn(insn, (AbstractInsnNode)new MethodInsnNode(182, "java/lang/ThreadLocal", "remove", "()V"));
                        this.removeInsn((AbstractInsnNode)min);
                        continue;
                    }
                }
                insn = insn.getNext();
            }
            if (!(this.disableAllocation || !createStack && usedTypes.isEmpty())) {
                this.insertStackVarBefore(insn, stackVar);
                LabelNode startLabel = new LabelNode();
                this.insertInsnBefore(insn, (AbstractInsnNode)startLabel);
                if (usedTypes.size() > 0) {
                    String[] typesArray = usedTypes.toArray(new String[usedTypes.size()]);
                    this.insertPush(insn, typesArray, stackVar);
                    for (insn = this.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                        if (!(insn instanceof InsnNode) || !this.isReturnOpcode(insn.getOpcode())) continue;
                        this.insertPop(insn, true, typesArray, stackVar);
                    }
                    LabelNode endLabel = new LabelNode();
                    insn = this.instructions.getLast();
                    insn = this.insertInsn(insn, (AbstractInsnNode)endLabel);
                    insn = this.insertPop(insn, false, typesArray, stackVar);
                    insn = this.insertInsn(insn, (AbstractInsnNode)new InsnNode(191));
                    this.tryCatchBlocks.add(new TryCatchBlockNode(startLabel, endLabel, endLabel, null));
                }
            }
            if (this.emitMethod) {
                this.accept(this.cv);
            }
        }
        catch (AnalyzerException e) {
            throw new IllegalStateException(e);
        }
    }

    private void removeInsn(AbstractInsnNode insn) {
        int idx = this.instructions.indexOf(insn);
        this.instructions.remove(insn);
        this.frames.remove(idx);
    }

    private AbstractInsnNode insertInsn(AbstractInsnNode insn, InsnList list) {
        if (list.size() == 0) {
            return insn;
        }
        int idx = this.instructions.indexOf(insn);
        for (int i = 0; i < list.size(); ++i) {
            this.frames.add(idx + 1, null);
        }
        AbstractInsnNode last = list.getLast();
        this.instructions.insert(insn, list);
        return last;
    }

    private void insertInsnBefore(AbstractInsnNode insn, InsnList list) {
        if (list.size() == 0) {
            return;
        }
        int idx = this.instructions.indexOf(insn);
        for (int i = 0; i < list.size(); ++i) {
            this.frames.add(idx, null);
        }
        this.instructions.insertBefore(insn, list);
    }

    private AbstractInsnNode insertInsn(AbstractInsnNode pos, AbstractInsnNode insn) {
        int idx = this.instructions.indexOf(pos);
        this.frames.add(idx + 1, null);
        this.instructions.insert(pos, insn);
        return insn;
    }

    private AbstractInsnNode insertInsnBefore(AbstractInsnNode pos, AbstractInsnNode insn) {
        int idx = this.instructions.indexOf(pos);
        this.frames.add(idx, null);
        this.instructions.insertBefore(pos, insn);
        return insn;
    }

    private boolean isReturnOpcode(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    private void insertStackVarBefore(AbstractInsnNode pos, int stackVar) {
        InsnList list = new InsnList();
        if (this.instr.isSingleThread()) {
            list.add((AbstractInsnNode)new FieldInsnNode(178, this.instr.getStackInternalName(), "INSTANCE", "L" + this.instr.getStackInternalName() + ";"));
            list.add((AbstractInsnNode)new VarInsnNode(58, stackVar));
        } else {
            String getDesc = Type.getMethodDescriptor((Type)Type.getObjectType((String)this.instr.getStackInternalName()), (Type[])new Type[0]);
            list.add((AbstractInsnNode)new MethodInsnNode(184, this.instr.getStackInternalName(), "get", getDesc));
            list.add((AbstractInsnNode)new VarInsnNode(58, stackVar));
        }
        this.insertInsnBefore(pos, list);
    }

    private void insertPush(AbstractInsnNode pos, String[] types, int stackVar) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, stackVar));
        for (int i = 0; i < types.length; ++i) {
            if (i < types.length - 1) {
                list.add((AbstractInsnNode)new InsnNode(89));
            }
            list.add((AbstractInsnNode)new MethodInsnNode(182, this.instr.getStackInternalName(), "push$" + Instrumenter.mangleInternalName(types[i]), "()V"));
        }
        this.insertInsnBefore(pos, list);
    }

    private AbstractInsnNode insertPop(AbstractInsnNode pos, boolean before, String[] types, int stackVar) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, stackVar));
        for (int i = 0; i < types.length; ++i) {
            if (i < types.length - 1) {
                list.add((AbstractInsnNode)new InsnNode(89));
            }
            list.add((AbstractInsnNode)new MethodInsnNode(182, this.instr.getStackInternalName(), "pop$" + Instrumenter.mangleInternalName(types[i]), "()V"));
        }
        if (before) {
            this.insertInsnBefore(pos, list);
            return null;
        }
        return this.insertInsn(pos, list);
    }

    private AbstractInsnNode replaceAllocClass(AbstractInsnNode pos, Type type, int stackVar) {
        InsnList list = new InsnList();
        if (this.disableAllocation) {
            list.add((AbstractInsnNode)new TypeInsnNode(187, type.getInternalName()));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, type.getInternalName(), "<init>", "()V"));
        } else if (this.staticAllocation) {
            int num = this.inscls.registerStaticAlloc(type.getInternalName());
            list.add((AbstractInsnNode)new FieldInsnNode(178, this.className, "$stackTemp" + num, type.getDescriptor()));
        } else {
            list.add((AbstractInsnNode)new VarInsnNode(25, stackVar));
            list.add((AbstractInsnNode)new MethodInsnNode(182, this.instr.getStackInternalName(), "get$" + Instrumenter.mangleInternalName(type.getInternalName()), "()" + type.getDescriptor()));
        }
        return this.insertInsn(pos, list);
    }

    private AbstractInsnNode replaceAllocObject(AbstractInsnNode pos, Type type, int stackVar) {
        InsnList list = new InsnList();
        if (this.disableAllocation) {
            list.add((AbstractInsnNode)new TypeInsnNode(187, type.getInternalName()));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, type.getInternalName(), "<init>", "()V"));
            list.add((AbstractInsnNode)new InsnNode(90));
            list.add((AbstractInsnNode)new InsnNode(95));
            Method m = StackGenerator.findGetMethodType(type.getInternalName());
            list.add((AbstractInsnNode)new MethodInsnNode(182, type.getInternalName(), "set", "(L" + Type.getInternalName(m.getParameterTypes()[0]) + ";)V"));
        } else if (this.staticAllocation) {
            int num = this.inscls.registerStaticAlloc(type.getInternalName());
            list.add((AbstractInsnNode)new FieldInsnNode(178, this.className, "$stackTemp" + num, type.getDescriptor()));
            list.add((AbstractInsnNode)new InsnNode(90));
            list.add((AbstractInsnNode)new InsnNode(95));
            Method m = StackGenerator.findGetMethodType(type.getInternalName());
            list.add((AbstractInsnNode)new MethodInsnNode(182, type.getInternalName(), "set", "(L" + Type.getInternalName(m.getParameterTypes()[0]) + ";)V"));
        } else {
            list.add((AbstractInsnNode)new VarInsnNode(25, stackVar));
            list.add((AbstractInsnNode)new InsnNode(95));
            list.add((AbstractInsnNode)new MethodInsnNode(182, this.instr.getStackInternalName(), "get$" + Instrumenter.mangleInternalName(type.getInternalName()), "(" + type.getDescriptor() + ")" + type.getDescriptor()));
        }
        return this.insertInsn(pos, list);
    }

    private void logError(String msg) {
        throw new IllegalStateException(msg + " (in class " + this.className.replace('/', '.') + ", method " + this.name + ")");
    }
}

