
import com.github.taymindis.NonSuckLockRequest;
import com.github.taymindis.NonSuckSSLIssueHttp;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;

public class HttpURLConnectionExample {

	public final static String getMD5Hash(String data) {
		String key = "123(271snSK";
		try {

			MessageDigest md5 = MessageDigest.getInstance("MD5");
			md5.update(data.getBytes());
			byte result[] = md5.digest(key.getBytes());
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < result.length; i++) {
				String s = Integer.toHexString(result[i]);
				int length = s.length();
				if (length >= 2) {
					sb.append(s.substring(length - 2, length));
				} else {
					sb.append("0");
					sb.append(s);
				}
			}
			return sb.toString();

		} catch (NoSuchAlgorithmException e) {
			return null;
		}
	}

	public final static String encodeHash(String data, String key) {
		return getMD5Hash(data + key).substring(0, 6) + "_" + data;
	}


	public static void main(String[] args) throws IOException, NoSuchAlgorithmException, KeyManagementException {
		String hash = encodeHash("50","sys_process");

		NonSuckSSLIssueHttp http = new NonSuckSSLIssueHttp(true);

		String url = "https://mykiehls.crmxs.com/?xs_process=lpdmy_consolidate&hours=7&defaultMbrLevelId=4500&excludebrandid=57&excludeproductid=26625%2C26626" +
				"&xs_processid="+hash;

		http.getRequest(url, NonSuckSSLIssueHttp.useXFormUrlEncoded());

		System.out.println(http.getStatusCode());
		System.out.println(http.getResponse());
		System.out.println(http.getErrMessage());



//		sendGET();
//		System.out.println("GET DONE");
//		sendPOST();
//		System.out.println("POST DONE");
	}



}
