/*
 * Decompiled with CFR 0.152.
 */
package com.github.taymindis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class NonSuckSSLIssueHttp {
    private int statusCode;
    private String response = null;
    private BufferedReader in = null;
    private String errMessage = null;
    private int connTimeout = 0;
    private int readTimeout = 0;
    private String charset = "UTF-8";
    private static final String USER_AGENT = "Mozilla/5.0";
    private boolean tls1_2 = true;

    public NonSuckSSLIssueHttp() {
    }

    public NonSuckSSLIssueHttp(boolean tls1_2) {
        this.tls1_2 = tls1_2;
    }

    public NonSuckSSLIssueHttp(int connTimeout, int readTimeout, boolean tls1_2) {
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.tls1_2 = tls1_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSSLTLS1_2Context(HttpsURLConnection con) {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(null, null, null);
            con.setSSLSocketFactory(context.getSocketFactory());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _request(HttpURLConnection con, Map<String, String> requestHeader, String requestBody) {
        boolean okToRead = true;
        if (this.tls1_2 && "https".equalsIgnoreCase(con.getURL().getProtocol())) {
            this.setSSLTLS1_2Context((HttpsURLConnection)con);
        }
        try {
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setUseCaches(false);
            con.setDoInput(true);
            if (requestHeader != null) {
                for (String key : requestHeader.keySet()) {
                    String value = requestHeader.get(key);
                    con.setRequestProperty(key, value);
                }
            }
            if (this.connTimeout > 0) {
                con.setConnectTimeout(this.connTimeout);
            }
            if (this.readTimeout > 0) {
                con.setReadTimeout(this.readTimeout);
            }
            if (requestBody != null) {
                byte[] postData = requestBody.getBytes(StandardCharsets.UTF_8);
                int postDataLength = postData.length;
                con.setRequestProperty("charset", "utf-8");
                con.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                con.setDoOutput(true);
                OutputStream os = null;
                try {
                    os = con.getOutputStream();
                    os.write(postData);
                }
                catch (IOException e) {
                    this.errMessage = e.getMessage();
                    this.setStatusCode(500);
                    okToRead = false;
                }
                finally {
                    if (os != null) {
                        os.flush();
                        os.close();
                    }
                }
            }
            if (!okToRead) {
                return;
            }
            int responseCode = con.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                String inputLine;
                this.in = new BufferedReader(new InputStreamReader(con.getInputStream(), this.charset));
                StringBuilder response = new StringBuilder();
                while ((inputLine = this.in.readLine()) != null) {
                    response.append(inputLine);
                }
                this.setStatusCode(responseCode);
                this.setResponse(response.toString());
            } else {
                this.setStatusCode(responseCode);
                this.setResponse(null);
            }
        }
        catch (IOException e) {
            this.setStatusCode(500);
            this.errMessage = e.getMessage();
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
                this.in = null;
            }
        }
    }

    public static Map<String, String> useJsonRequestResponseContentType() {
        return new HashMap<String, String>(){
            {
                this.put("Content-Type", "application/json; charset=UTF-8");
                this.put("Accept", "application/json");
            }
        };
    }

    public static Map<String, String> useXFormUrlEncoded() {
        return new HashMap<String, String>(){
            {
                this.put("Content-Type", "application/x-www-form-urlencoded");
            }
        };
    }

    public static Map<String, String> useMultiPartFormData() {
        final String boundary = "*****" + Long.toString(System.currentTimeMillis()) + "*****";
        return new HashMap<String, String>(){
            {
                this.put("Content-Type", "multipart/form-data; boundary=" + boundary);
            }
        };
    }

    public void getRequest(String url, Map<String, String> requestHeader) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        this._request(con, requestHeader, null);
    }

    public void postRequest(String url, Map<String, String> requestHeader, String requestBody) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        this._request(con, requestHeader, requestBody);
    }

    public void postRequest(String url, Map<String, String> requestHeader, Map<String, Object> params) throws IOException {
        this.postRequest(url, requestHeader, NonSuckSSLIssueHttp.paramToStringBody(params));
    }

    public void putRequest(String url, Map<String, String> requestHeader, String requestBody) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("PUT");
        this._request(con, requestHeader, requestBody);
    }

    public void putRequest(String url, Map<String, String> requestHeader, Map<String, Object> params) throws IOException {
        this.putRequest(url, requestHeader, NonSuckSSLIssueHttp.paramToStringBody(params));
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    public void setErrMessage(String errMessage) {
        this.errMessage = errMessage;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void release() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                this.errMessage = e.getMessage();
            }
            this.in = null;
        }
    }

    private static String paramToStringBody(Map<String, Object> params) {
        if (params != null && !params.isEmpty()) {
            StringBuilder postData = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                postData.append('&');
                postData.append(param.getKey());
                postData.append('=');
                postData.append(param.getValue());
            }
            return postData.deleteCharAt(0).toString();
        }
        return null;
    }
}

