/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy;

import com.github.thomasridd.flatsy.FlatsyDatabase;
import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import com.github.thomasridd.flatsy.operations.operators.UriToMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FlatsyFlatFileDatabase
implements FlatsyDatabase {
    Path root;

    public FlatsyFlatFileDatabase(Path root) {
        this.root = root;
    }

    public String toString() {
        return this.root.toString();
    }

    @Override
    public FlatsyObject root() {
        return this.get("");
    }

    @Override
    public FlatsyObject get(String uri) {
        return new FlatsyObject(uri, this);
    }

    @Override
    public void create(FlatsyObject object, String content) {
        Path path = this.toPath(object.uri);
        try {
            path.toFile().getParentFile().mkdirs();
            Files.write(path, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.out.println("Error in create " + object.uri);
        }
    }

    @Override
    public void create(FlatsyObject object, InputStream content) throws IOException {
        Path path = this.toPath(object.uri);
        path.toFile().getParentFile().mkdirs();
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            IOUtils.copy((InputStream)content, (OutputStream)outputStream);
        }
    }

    @Override
    public String retrieve(FlatsyObject object) {
        Path path = this.toPath(object.uri);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        String content = null;
        try {
            content = new Scanner(path.toFile()).useDelimiter("//Z").next();
        }
        catch (Exception e) {
            System.out.println("Error in " + object.uri);
            return "Error";
        }
        return content;
    }

    @Override
    public InputStream retrieveStream(FlatsyObject object) throws IOException {
        Path path = this.toPath(object.uri);
        return Files.newInputStream(path, new OpenOption[0]);
    }

    @Override
    public <T> Object retrieveAs(FlatsyObject object, Class<T> tClass) {
        return null;
    }

    @Override
    public void update(FlatsyObject object, FlatsyOperator update) {
        object.apply(update);
    }

    @Override
    public void delete(FlatsyObject object) {
        Path path = this.toPath(object.uri);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            System.out.println("error in delete: " + object.uri);
        }
    }

    @Override
    public List<FlatsyObject> children(FlatsyObject object) {
        ArrayList<FlatsyObject> objects = new ArrayList<FlatsyObject>();
        Path path = this.toPath(object.uri);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path p : directoryStream) {
                objects.add(new FlatsyObject(this.root.relativize(p).toString(), this));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return objects;
    }

    @Override
    public FlatsyObject parent(FlatsyObject object) {
        if (object.equals(object.db.root())) {
            return null;
        }
        Path path = this.toPath(object.uri).getParent();
        return new FlatsyObject(this.root.relativize(path).toString(), this);
    }

    @Override
    public void move(FlatsyObject object, String newUri) {
        Path oldPath = this.root.resolve(object.uri);
        Path newPath = this.root.resolve(newUri);
        try {
            if (object.getType() == FlatsyObjectType.Folder) {
                if (Files.exists(newPath, new LinkOption[0])) {
                    for (FlatsyObject child : object.children()) {
                        String newChildUri = this.moveFilename(child, object.uri, newUri);
                        this.move(child, newChildUri);
                    }
                    FileUtils.deleteDirectory((File)oldPath.toFile());
                } else {
                    FileUtils.moveDirectory((File)oldPath.toFile(), (File)newPath.toFile());
                }
            } else if (object.getType() == FlatsyObjectType.JSONFile || object.getType() == FlatsyObjectType.OtherFile) {
                FileUtils.moveFile((File)oldPath.toFile(), (File)newPath.toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, String> moveMap(FlatsyObject object, String newUri) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        object.apply(new UriToMap(map, newUri));
        for (String key : map.keySet()) {
            String newFilename = this.moveFilename(new FlatsyObject(key, object.db), object.uri, newUri);
            map.put(key, newFilename);
        }
        return map;
    }

    String moveFilename(FlatsyObject objectToMove, String oldUri, String newUri) {
        if (!objectToMove.uri.startsWith(oldUri)) {
            return objectToMove.uri;
        }
        return newUri + objectToMove.uri.substring(oldUri.length());
    }

    @Override
    public FlatsyObjectType type(String uri) {
        Path path = this.root.resolve(uri);
        if (!Files.exists(path, new LinkOption[0])) {
            return FlatsyObjectType.Null;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return FlatsyObjectType.Folder;
        }
        if (uri.endsWith(".json")) {
            return FlatsyObjectType.JSONFile;
        }
        return FlatsyObjectType.OtherFile;
    }

    private Path toPath(String uri) {
        if (uri.startsWith("/")) {
            return this.root.resolve(uri.substring(1));
        }
        return this.root.resolve(uri);
    }
}

