/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy;

import com.github.thomasridd.flatsy.FlatsyDatabase;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import com.github.thomasridd.flatsy.query.FlatsyCursor;
import com.github.thomasridd.flatsy.query.FlatsyQuery;
import com.github.thomasridd.flatsy.query.FlatsyQueryType;
import com.github.thomasridd.flatsy.query.matchers.All;
import com.github.thomasridd.flatsy.query.matchers.FlatsyMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class FlatsyObject
implements Comparable {
    public FlatsyDatabase db;
    public String uri;

    public FlatsyObject(String uri, FlatsyDatabase db) {
        this.uri = uri.toLowerCase();
        if (this.uri.startsWith("/")) {
            this.uri = this.uri.substring(1);
        }
        this.db = db;
    }

    public FlatsyObjectType getType() {
        return this.db.type(this.uri);
    }

    public FlatsyCursor query(FlatsyMatcher flatsyMatcher) {
        return new FlatsyCursor(this, new FlatsyQuery(flatsyMatcher));
    }

    public FlatsyCursor query(FlatsyQueryType type, FlatsyMatcher flatsyMatcher) {
        return new FlatsyCursor(this, new FlatsyQuery(type, flatsyMatcher));
    }

    public FlatsyCursor query(String flatsyQuery) {
        return new FlatsyCursor(this, new FlatsyQuery(flatsyQuery));
    }

    public FlatsyCursor cursor() {
        return new FlatsyCursor(this, new FlatsyQuery(new All()));
    }

    public void apply(FlatsyOperator operator) {
        this.cursor().apply(operator);
    }

    public String retrieve() throws IOException {
        return this.db.retrieve(this);
    }

    public InputStream retrieveStream() throws IOException {
        return this.db.retrieveStream(this);
    }

    public void create(String content) {
        this.db.create(this, content);
    }

    public void create(InputStream stream) throws IOException {
        this.db.create(this, stream);
    }

    public List<FlatsyObject> children() {
        return this.db.children(this);
    }

    public FlatsyObject parent() {
        return this.db.parent(this);
    }

    public int compareTo(Object o) {
        FlatsyObject obj = (FlatsyObject)o;
        return this.uri.compareTo(obj.uri);
    }
}

