/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.operations.operators;

import com.github.thomasridd.flatsy.FlatsyDatabase;
import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import com.github.thomasridd.flatsy.util.FlatsyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class CopyTo
implements FlatsyOperator {
    FlatsyDatabase db;
    String newUriExpression;
    boolean copySiblings = false;

    public CopyTo(FlatsyDatabase db, String newUriExpression) {
        this.db = db;
        this.newUriExpression = newUriExpression;
    }

    public CopyTo(FlatsyDatabase db, String newUriExpression, boolean copySiblings) {
        this.db = db;
        this.newUriExpression = newUriExpression;
        this.copySiblings = copySiblings;
    }

    @Override
    public void apply(FlatsyObject object) {
        if (object.getType() == FlatsyObjectType.Folder || object.getType() == FlatsyObjectType.Null) {
            return;
        }
        ArrayList<FlatsyObject> objectList = new ArrayList<FlatsyObject>();
        if (this.copySiblings) {
            for (FlatsyObject sibling : object.parent().children()) {
                objectList.add(sibling);
            }
        } else {
            objectList.add(object);
        }
        for (FlatsyObject copyObject : objectList) {
            if (copyObject.getType() == FlatsyObjectType.Folder) continue;
            try {
                String destination = FlatsyUtil.stringExpression(this.newUriExpression, copyObject);
                FlatsyObject destinationObject = new FlatsyObject(destination, this.db);
                if (destination.equalsIgnoreCase(copyObject.uri) && object.db.toString().equalsIgnoreCase(this.db.toString())) continue;
                this.db.delete(destinationObject);
                InputStream stream = copyObject.retrieveStream();
                Throwable throwable = null;
                try {
                    this.db.create(destinationObject, stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

