/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.operations.operators;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class JSONPathsToOutput
implements FlatsyOperator {
    OutputStream stream;
    List<String> paths;

    public JSONPathsToOutput(OutputStream stream, List<String> paths) {
        this.stream = stream;
        this.paths = paths;
    }

    @Override
    public void apply(FlatsyObject object) {
        try {
            String objectString = object.uri + "\t";
            DocumentContext context = JsonPath.parse((InputStream)object.retrieveStream());
            for (String path : this.paths) {
                try {
                    String value = (String)context.read(path, new Predicate[0]);
                    value = value.replace("\n", " ").replace("\r", " ");
                    objectString = objectString + value + "\t";
                }
                catch (PathNotFoundException e) {
                    objectString = objectString + "\t";
                }
            }
            this.stream.write((objectString + "\n").getBytes());
        }
        catch (IOException e) {
            System.out.println("Failed to print for uri: " + object.uri);
        }
    }
}

