/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.operations.operators;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;

public class JSONValidate
implements FlatsyOperator {
    private static final Gson gson = new Gson();

    @Override
    public void apply(FlatsyObject object) {
        try {
            if (!this.validateJSON(object)) {
                System.out.println("invalide json for " + object.uri);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to print for uri: " + object.uri);
        }
    }

    public boolean validateJSON(FlatsyObject object) throws IOException {
        String json = object.retrieve();
        return JSONValidate.isJSONValid(json);
    }

    public static boolean isJSONValid(String json) {
        try {
            gson.fromJson(json, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }
}

