/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.operations.operators;

import com.github.thomasridd.flatsy.FlatsyFlatFileDatabase;
import com.github.thomasridd.flatsy.operations.operators.Copy;
import com.github.thomasridd.flatsy.operations.operators.CopyTo;
import com.github.thomasridd.flatsy.operations.operators.JSONPathAdd;
import com.github.thomasridd.flatsy.operations.operators.JSONPathPut;
import com.github.thomasridd.flatsy.operations.operators.JSONPathsToOutput;
import com.github.thomasridd.flatsy.operations.operators.Replace;
import com.github.thomasridd.flatsy.operations.operators.UriToOutput;
import com.github.thomasridd.flatsy.query.FlatsyCursor;
import com.github.thomasridd.flatsy.util.FlatsyUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;

public class OperatorCommandLineParser {
    public static void applyFromCommand(FlatsyCursor cursor, String command) {
        OperatorCommandLineParser.applyFromCommand(cursor, command, System.out);
    }

    public static void applyFromCommand(FlatsyCursor cursor, String command, OutputStream defaultOut) {
        List<String> args = FlatsyUtil.commandArguments(command);
        String action = args.get(0);
        if (action.equalsIgnoreCase("copy")) {
            cursor.apply(new Copy(new FlatsyFlatFileDatabase(Paths.get(args.get(1), new String[0]))));
        } else if (action.equalsIgnoreCase("copy_to")) {
            cursor.apply(new CopyTo(new FlatsyFlatFileDatabase(Paths.get(args.get(1), new String[0])), args.get(2)));
        } else if (action.equalsIgnoreCase("folder_copy")) {
            cursor.apply(new Copy(new FlatsyFlatFileDatabase(Paths.get(args.get(1), new String[0])), true));
        } else if (action.equalsIgnoreCase("folder_copy_to")) {
            cursor.apply(new CopyTo(new FlatsyFlatFileDatabase(Paths.get(args.get(1), new String[0])), args.get(2), true));
        } else if (action.equalsIgnoreCase("replace")) {
            cursor.apply(new Replace(args.get(1), args.get(2)));
        } else if (action.equalsIgnoreCase("list")) {
            if (args.size() > 1) {
                try (OutputStream stream = Files.newOutputStream(Paths.get(args.get(1), new String[0]), new OpenOption[0]);){
                    cursor.apply(new UriToOutput(stream));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                cursor.apply(new UriToOutput(defaultOut));
            }
        } else if (action.equalsIgnoreCase("table")) {
            List<String> paths = args.subList(1, args.size());
            if (!paths.get(0).startsWith("$")) {
                try (OutputStream stream = Files.newOutputStream(Paths.get(paths.get(0), new String[0]), new OpenOption[0]);){
                    cursor.apply(new JSONPathsToOutput(stream, paths.subList(1, paths.size())));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                cursor.apply(new JSONPathsToOutput(defaultOut, paths));
            }
        } else if (action.equalsIgnoreCase("jsonpath")) {
            String jsonpath = args.get(1);
            String jsonAction = args.get(2);
            if (jsonAction.equalsIgnoreCase("add")) {
                if (args.size() >= 5) {
                    String jsonField = args.get(3);
                    String jsonValue = args.get(4);
                    cursor.apply(new JSONPathAdd(jsonpath, jsonField, jsonValue));
                }
            } else if (jsonAction.equalsIgnoreCase("put") && args.size() >= 5) {
                String jsonField = args.get(3);
                String jsonValue = args.get(4);
                cursor.apply(new JSONPathPut(jsonpath, jsonField, jsonValue));
            }
        }
    }
}

