/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.query;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.operations.FlatsyWorker;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperatorBuilder;
import com.github.thomasridd.flatsy.query.FlatsyQuery;
import com.github.thomasridd.flatsy.query.FlatsyQueryResult;
import com.github.thomasridd.flatsy.query.FlatsyQueryType;
import com.github.thomasridd.flatsy.query.matchers.FlatsyMatcher;
import com.github.thomasridd.flatsy.query.matchers.MatcherCommandLineParser;
import java.util.ArrayList;
import java.util.List;

public class FlatsyCursor {
    FlatsyQuery query = null;
    int depth = 0;
    List<FlatsyObject> tree = new ArrayList<FlatsyObject>();
    List<List<FlatsyObject>> nodes = new ArrayList<List<FlatsyObject>>();
    List<Integer> treePosition = new ArrayList<Integer>();
    boolean onNextStepMoveDownTree = false;

    public FlatsyCursor(FlatsyObject cursorRoot, FlatsyQuery query) {
        this(cursorRoot);
        this.query = query;
    }

    public FlatsyCursor(FlatsyObject cursorRoot) {
        this.tree.add(cursorRoot);
        ArrayList<FlatsyObject> asList = new ArrayList<FlatsyObject>();
        asList.add(cursorRoot);
        this.nodes.add(asList);
        this.treePosition.add(-1);
        this.query = null;
    }

    public void apply(FlatsyOperator operation) {
        FlatsyWorker worker = new FlatsyWorker(operation);
        worker.updateAll(this);
    }

    public void apply(String operation) {
        FlatsyWorker worker = new FlatsyWorker(FlatsyOperatorBuilder.operatorStringToOperator(operation));
        worker.updateAll(this);
    }

    public FlatsyObject currentObject() {
        try {
            return this.nodes.get(this.depth).get(this.treePosition.get(this.depth));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean next() {
        boolean found = false;
        while (this.depth >= 0) {
            found = this.takeStep();
            if (!found) continue;
            return true;
        }
        return false;
    }

    public List<FlatsyObject> getAll() {
        ArrayList<FlatsyObject> list = new ArrayList<FlatsyObject>();
        while (this.next()) {
            list.add(this.currentObject());
        }
        return list;
    }

    boolean takeStep() {
        if (this.onNextStepMoveDownTree) {
            this.stepDownTree();
            this.onNextStepMoveDownTree = false;
        }
        if (this.treePosition.get(this.depth) >= this.nodes.get(this.depth).size() - 1) {
            this.stepUpTree();
            return false;
        }
        this.treePosition.set(this.depth, this.treePosition.get(this.depth) + 1);
        FlatsyObject current = this.nodes.get(this.depth).get(this.treePosition.get(this.depth));
        FlatsyQueryResult result = this.query.checkNode(current);
        if (result == FlatsyQueryResult.Blocked) {
            return false;
        }
        if (result == FlatsyQueryResult.MatchThenBlock) {
            this.onNextStepMoveDownTree = false;
            return true;
        }
        if (result == FlatsyQueryResult.Match) {
            this.onNextStepMoveDownTree = true;
            return true;
        }
        this.onNextStepMoveDownTree = true;
        return false;
    }

    private void stepUpTree() {
        this.treePosition.remove(this.treePosition.size() - 1);
        this.nodes.remove(this.nodes.size() - 1);
        this.tree.remove(this.tree.size() - 1);
        --this.depth;
    }

    private void stepDownTree() {
        FlatsyObject current = this.nodes.get(this.depth).get(this.treePosition.get(this.depth));
        this.tree.add(current);
        this.nodes.add(current.children());
        this.treePosition.add(-1);
        ++this.depth;
    }

    public FlatsyCursor query(FlatsyQueryType type, FlatsyMatcher matcher) {
        if (this.query == null) {
            this.query = new FlatsyQuery().query(type, matcher);
        } else {
            this.query.query(type, matcher);
        }
        return this;
    }

    public FlatsyCursor query(FlatsyMatcher matcher) {
        return this.query(FlatsyQueryType.Condition, matcher);
    }

    public FlatsyCursor query(String queryString) {
        return MatcherCommandLineParser.query(this, queryString);
    }
}

