/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.util;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlatsyUtil {
    public static List<String> commandArguments(String command) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(command);
        while (m.find()) {
            list.add(m.group(1).replace("\"", ""));
        }
        return list;
    }

    public static String stringExpression(String expression, FlatsyObject object) throws IOException {
        String[] split;
        ArrayList<String> list = new ArrayList<String>();
        String replaced = expression.replace("++", "+ \" \" +");
        for (String item : split = replaced.split("\\+(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)")) {
            list.add(item.trim().replace("\"", ""));
        }
        String result = "";
        for (String item : list) {
            if (item.equalsIgnoreCase("~.uri")) {
                result = result + object.uri;
                continue;
            }
            if (item.equalsIgnoreCase("~.file")) {
                if (object.getType() != FlatsyObjectType.JSONFile && object.getType() != FlatsyObjectType.OtherFile) continue;
                Path p = Paths.get(object.uri, new String[0]);
                result = result + p.getFileName().toString();
                continue;
            }
            if (item.equalsIgnoreCase("~.parent")) {
                if (object.parent() == null) continue;
                result = result + object.parent().uri;
                continue;
            }
            if (item.startsWith("$.")) {
                DocumentContext context = JsonPath.parse((InputStream)object.retrieveStream());
                try {
                    String value = (String)context.read(item, new Predicate[0]);
                    value = value.replace("\n", " ").replace("\r", " ");
                    result = result + value;
                }
                catch (PathNotFoundException e) {
                    result = result + ".";
                }
                continue;
            }
            result = result + item;
        }
        return result;
    }
}

