/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.query.matchers;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.query.matchers.FlatsyMatcher;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelValidXLS
implements FlatsyMatcher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean matches(FlatsyObject object) {
        if (object.getType() == FlatsyObjectType.Folder) {
            return false;
        }
        try (InputStream stream = object.retrieveStream();){
            if (ExcelValidXLS.isXLSValid(stream)) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isXLSValid(InputStream stream) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(stream);
            workbook.getSheetAt(0);
            return true;
        }
        catch (OldExcelFormatException e) {
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }
}

