/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals;

import com.github.writethemfirst.approvals.Approvals;
import com.github.writethemfirst.approvals.CombinationApprover;
import com.github.writethemfirst.approvals.FolderApprover;
import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.files.ApprovalFiles;
import com.github.writethemfirst.approvals.reporters.ThrowsReporter;
import com.github.writethemfirst.approvals.utils.FileUtils;
import com.github.writethemfirst.approvals.utils.StackUtils;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Approver {
    final Class<?> testClass;
    private final Path folder;
    final Reporter reporter;
    final String customFileName;
    final String customExtension;

    public Approver() {
        this(Reporter.DEFAULT, null, "", StackUtils.callerClass(Approver.class, Approvals.class, FolderApprover.class, CombinationApprover.class));
    }

    Approver(Reporter reporter, String customFileName, String customExtension, Class<?> testClass) {
        this.reporter = reporter;
        this.customFileName = customFileName;
        this.customExtension = customExtension;
        this.testClass = testClass;
        this.folder = Approver.folderForClass(testClass);
    }

    public Approver reportTo(Reporter reporter) {
        return new Approver(reporter, this.customFileName, this.customExtension, this.testClass);
    }

    public Approver writeTo(String customFileName) {
        return new Approver(this.reporter, customFileName, this.customExtension, this.testClass);
    }

    public Approver testing(Class<?> testClass) {
        return new Approver(this.reporter, this.customFileName, this.customExtension, testClass);
    }

    public void verify(Object output) {
        ApprovalFiles files = this.approvedAndReceivedPaths();
        this.writeReceivedFile(output, files);
        FileUtils.createFileIfNeeded(files.approved);
        if (files.haveSameContent()) {
            FileUtils.silentRemove(files.received);
        } else {
            this.reporter.mismatch(files.approved, files.received);
            new ThrowsReporter().mismatch(files.approved, files.received);
        }
    }

    void writeReceivedFile(Object output, ApprovalFiles files) {
        FileUtils.write(output + "", files.received);
    }

    private static Path folderForClass(Class<?> testClass) {
        String packageName = testClass.getPackage().getName();
        Path packageResourcesPath = Paths.get("src/test/resources/", packageName.split("\\."));
        return packageResourcesPath.resolve(testClass.getSimpleName());
    }

    private String callerMethodName() {
        return StackUtils.callerMethod(this.testClass).orElse("unknown_method");
    }

    ApprovalFiles approvedAndReceivedPaths() {
        return ApprovalFiles.build(this.folder, this.customFileName != null ? this.customFileName : this.callerMethodName(), this.customExtension);
    }
}

