/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StackUtils {
    public static Class<?> callerClass(Class<?> ... referenceClass) {
        List<String> classesInStack = StackUtils.distinctClassesInStack();
        int referenceIndex = StackUtils.positionFromLastReferenceInStack(classesInStack, referenceClass);
        String callerClassName = classesInStack.get(referenceIndex + 1);
        try {
            return Class.forName(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Unexpected exception", e);
        }
    }

    private static int positionFromLastReferenceInStack(List<String> classesInStack, Class<?>[] referenceClasses) {
        ArrayList<String> reversedStack = new ArrayList<String>(classesInStack);
        Collections.reverse(reversedStack);
        Optional<String> lastReferenceName = reversedStack.stream().filter(className -> Arrays.stream(referenceClasses).anyMatch(referenceClass -> className.equals(referenceClass.getName()))).findFirst();
        return classesInStack.indexOf(lastReferenceName.get());
    }

    private static List<String> distinctClassesInStack() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).distinct().collect(Collectors.toList());
    }

    public static Optional<String> callerMethod(Class<?> referenceClass) {
        String referenceClassName = referenceClass.getName();
        return Arrays.stream(Thread.currentThread().getStackTrace()).filter(e -> e.getClassName().equals(referenceClassName)).filter(e -> !e.getMethodName().startsWith("lambda$")).map(StackTraceElement::getMethodName).findFirst();
    }
}

