/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

abstract class SharedPreferencesCompat {
    private static final Method sApplyMethod = SharedPreferencesCompat.findApplyMethod();

    private SharedPreferencesCompat() {
    }

    private static Method findApplyMethod() {
        try {
            Class<SharedPreferences.Editor> cls = SharedPreferences.Editor.class;
            return cls.getMethod("apply", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void apply(SharedPreferences.Editor editor) {
        if (sApplyMethod != null) {
            try {
                sApplyMethod.invoke((Object)editor, new Object[0]);
                return;
            }
            catch (InvocationTargetException unused) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        editor.commit();
    }
}

