/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus.impl;

import com.googlecode.googleplus.CommentOperations;
import com.googlecode.googleplus.Paging;
import com.googlecode.googleplus.PlusUtils;
import com.googlecode.googleplus.model.comment.Comment;
import com.googlecode.googleplus.model.comment.CommentFeed;
import java.util.Map;
import org.springframework.web.client.RestTemplate;

public class CommentOperationsImpl
implements CommentOperations {
    private static final String LIST_URL = "https://www.googleapis.com/plus/v1/activities/{activityId}/comments";
    private static final String GET_URL = "https://www.googleapis.com/plus/v1/comments/{commentId}";
    private RestTemplate restTemplate;

    public CommentOperationsImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public CommentFeed list(String activityId, Paging paging) {
        Map<String, String> params = PlusUtils.createParamMap(paging);
        return (CommentFeed)this.restTemplate.getForObject(PlusUtils.addParameters(LIST_URL, params), CommentFeed.class, new Object[]{activityId});
    }

    public CommentFeed list(String activityId) {
        return this.list(activityId, null);
    }

    public Comment get(String commentId) {
        return (Comment)this.restTemplate.getForObject(GET_URL, Comment.class, new Object[]{commentId});
    }
}

