/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus.impl;

import com.googlecode.googleplus.Paging;
import com.googlecode.googleplus.PeopleOperations;
import com.googlecode.googleplus.PlusUtils;
import com.googlecode.googleplus.model.activity.ActivityPeopleCollection;
import com.googlecode.googleplus.model.person.PeopleCollection;
import com.googlecode.googleplus.model.person.Person;
import com.googlecode.googleplus.model.person.PersonFeed;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class PeopleOperationsImpl
implements PeopleOperations {
    private static String GET_URL = "https://www.googleapis.com/plus/v1/people/{id}";
    private static final String SEARCH_URL = "https://www.googleapis.com/plus/v1/people";
    private static final String GET_BY_ACTIVITY_URL = "https://www.googleapis.com/plus/v1/activities/{activityId}/people/{collection}";
    private static final String LIST_URL = "https://www.googleapis.com/plus/v1/people/{userId}/people/{collection}";
    private RestTemplate restTemplate;

    public PeopleOperationsImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public Person get(String id) {
        Assert.notNull((Object)id);
        return (Person)this.restTemplate.getForObject(GET_URL, Person.class, new Object[]{id});
    }

    public PersonFeed search(String query, Paging paging) {
        Map<String, String> params = PlusUtils.createParamMap(paging);
        if (query != null) {
            params.put("query", query);
        }
        return (PersonFeed)this.restTemplate.getForObject(PlusUtils.addParameters(SEARCH_URL, params), PersonFeed.class, new Object[0]);
    }

    public PersonFeed search(String query) {
        return this.search(query, null);
    }

    public PersonFeed listByActivity(String activityId, ActivityPeopleCollection collection) {
        return this.listByActivity(activityId, collection, null);
    }

    public PersonFeed listByActivity(String activityId, ActivityPeopleCollection collection, Paging paging) {
        Assert.notNull((Object)activityId);
        Assert.notNull((Object)((Object)collection));
        Map<String, String> params = PlusUtils.createParamMap(paging);
        return (PersonFeed)this.restTemplate.getForObject(PlusUtils.addParameters(GET_BY_ACTIVITY_URL, params), PersonFeed.class, new Object[]{activityId, collection.getCollectionName()});
    }

    public PersonFeed list(String userId, PeopleCollection collection) {
        return this.list(userId, collection, null);
    }

    public PersonFeed list(String userId, PeopleCollection collection, Paging paging) {
        Assert.notNull((Object)userId);
        Assert.notNull((Object)((Object)collection));
        Map<String, String> params = PlusUtils.createParamMap(paging);
        return (PersonFeed)this.restTemplate.getForObject(PlusUtils.addParameters(LIST_URL, params), PersonFeed.class, new Object[]{userId, collection.getCollectionName()});
    }
}

