/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Client;
import com.labstack.Log;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Logging {
    private OkHttpClient okHttp;
    private Timer timer;
    private List<Log> logs = Collections.synchronizedList(new ArrayList());
    private String appId;
    private String appName;
    private String[] tags;
    private String level;
    private int batchSize;
    private int dispatchInterval;
    private static final Map<String, Integer> LEVELS = new HashMap<String, Integer>();
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String WARN = "WARN";
    public static final String ERROR = "ERROR";

    private void dispatch() throws Exception {
        if (this.logs.size() == 0) {
            return;
        }
        Moshi moshi = new Moshi.Builder().build();
        ParameterizedType type = Types.newParameterizedType(List.class, (Type[])new Type[]{Log.class});
        JsonAdapter jsonAdapter = moshi.adapter((Type)type);
        String json = jsonAdapter.toJson(this.logs);
        Request request = new Request.Builder().url("https://api.labstack.com/logging").post(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
        Response response = this.okHttp.newCall(request).execute();
        if (response.code() != 204) {
            throw new Exception(String.format("logging: error dispatching logs, status=%d, message=%v", response.code(), response.body()));
        }
    }

    public void setOkHttp(OkHttpClient okHttp) {
        this.okHttp = okHttp;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setDispatchInterval(int dispatchInterval) {
        this.dispatchInterval = dispatchInterval;
    }

    public void debug(String format, Object ... args) {
        this.log(DEBUG, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(INFO, format, args);
    }

    public void warn(String format, Object ... args) {
        this.log(WARN, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(ERROR, format, args);
    }

    public void log(String level, String format, Object ... args) {
        if (LEVELS.get(level) < LEVELS.get(this.level)) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        Logging.this.dispatch();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, TimeUnit.SECONDS.toMillis(this.dispatchInterval));
        }
        String message = String.format(format, args);
        Log log = new Log(this.appId, this.appName, this.tags, this.level, message);
        this.logs.add(log);
        if (this.logs.size() >= this.batchSize) {
            try {
                this.dispatch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logs.clear();
        }
    }

    static {
        LEVELS.put(DEBUG, 1);
        LEVELS.put(INFO, 2);
        LEVELS.put(WARN, 3);
        LEVELS.put(ERROR, 4);
    }
}

