/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.ehcache;

import com.litongjava.db.IPlugin;
import com.litongjava.db.ehcache.CacheKit;
import java.io.InputStream;
import java.net.URL;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;

public class EhCachePlugin
implements IPlugin {
    private static CacheManager cacheManager;
    private String configurationFileName;
    private URL configurationFileURL;
    private InputStream inputStream;
    private Configuration configuration;

    public EhCachePlugin() {
    }

    public EhCachePlugin(CacheManager cacheManager) {
        EhCachePlugin.cacheManager = cacheManager;
    }

    public EhCachePlugin(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public EhCachePlugin(URL configurationFileURL) {
        this.configurationFileURL = configurationFileURL;
    }

    public EhCachePlugin(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public EhCachePlugin(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean start() {
        this.createCacheManager();
        CacheKit.init(cacheManager);
        return true;
    }

    private void createCacheManager() {
        if (cacheManager != null) {
            return;
        }
        if (this.configurationFileName != null) {
            cacheManager = CacheManager.create((String)this.configurationFileName);
            return;
        }
        if (this.configurationFileURL != null) {
            cacheManager = CacheManager.create((URL)this.configurationFileURL);
            return;
        }
        if (this.inputStream != null) {
            cacheManager = CacheManager.create((InputStream)this.inputStream);
            return;
        }
        if (this.configuration != null) {
            cacheManager = CacheManager.create((Configuration)this.configuration);
            return;
        }
        cacheManager = CacheManager.create();
    }

    @Override
    public boolean stop() {
        cacheManager.shutdown();
        cacheManager = null;
        return true;
    }
}

