/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.satoken;

import com.litongjava.db.redis.serializer.ISerializer;
import com.litongjava.db.redis.serializer.JdkSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.util.SafeEncoder;

public class SaJdkSerializer
implements ISerializer {
    private static final Logger log = LoggerFactory.getLogger(SaJdkSerializer.class);
    public static final ISerializer me = new JdkSerializer();

    @Override
    public byte[] keyToBytes(String key) {
        return SafeEncoder.encode((String)key);
    }

    @Override
    public String keyFromBytes(byte[] bytes) {
        return SafeEncoder.encode((byte[])bytes);
    }

    @Override
    public byte[] fieldToBytes(Object field) {
        return this.valueToBytes(field);
    }

    @Override
    public Object fieldFromBytes(byte[] bytes) {
        return this.valueFromBytes(bytes);
    }

    @Override
    public byte[] valueToBytes(Object value) {
        ObjectOutputStream objectOut = null;
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(1024);
            objectOut = new ObjectOutputStream(bytesOut);
            objectOut.writeObject(value);
            objectOut.flush();
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public Object valueFromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectInputStream objectInput = null;
        try {
            ByteArrayInputStream bytesInput = new ByteArrayInputStream(bytes);
            objectInput = new ObjectInputStream(bytesInput);
            Object object = objectInput.readObject();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (objectInput != null) {
                try {
                    objectInput.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

